<?php

use app\components\widgets\ConditionsBuilder;
use app\helpers\EventHelper;
use app\modules\addons\modules\stripe\helpers\Client;
use app\modules\addons\modules\stripe\models\Stripe;
use yii\helpers\Html;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;
use yii\web\View;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\stripe\models\Stripe */

$this->registerJsFile('@web/static_files/js/buttonstrip.min.js');
$this->registerJs('
    // display correct checkout   
    function updateCheckout() {
        // check which payment option was selected and which payment method was selected
        var paymentOption = $("#payment-options").find(".Tab--selected").find(".TabLabel").html();
        var paymentMethod = $("#payment-methods").find(".Tab--selected").find(".TabLabel").html();
        
        if (paymentOption == "Pay Now" && paymentMethod == "ACH Transfer") {
            $("#full-ach").show();
            $("#full-card").hide();
            $("#subscribe-ach").hide();
            $("#subscribe-card").hide();
        }
        else if (paymentOption == "Pay Now" && paymentMethod == "Card") {
            $("#full-ach").hide();
            $("#full-card").show();
            $("#subscribe-ach").hide();
            $("#subscribe-card").hide();
        }
        else if (paymentOption == "Pay in Installments" && paymentMethod == "ACH Transfer") {
            $("#full-ach").hide();
            $("#full-card").hide();
            $("#subscribe-ach").show();
            $("#subscribe-card").hide();
        }
        else if (paymentOption == "Pay in Installments" && paymentMethod == "Card") {
            $("#full-ach").hide();
            $("#full-card").hide();
            $("#subscribe-ach").hide();
            $("#subscribe-card").show();
        }
        
        var previousSubtotal = Number($("#checkout_subtotal").html().replace(/[^0-9.-]+/g,""));
        updateCheckoutNumbers(previousSubtotal);
    }
    
    function updatePaymentOptionButton(updatedPaymentOption) {
        if (updatedPaymentOption == "full") {
            $("#payment-options").find("#pay-now").addClass("Tab--selected");
            $("#payment-options").find("#pay-plan").removeClass("Tab--selected");
            $("#payment-options").find("#pay-now").find("svg").addClass("p-TabIcon--selected");
            $("#payment-options").find("#pay-plan").find("svg").removeClass("p-TabIcon--selected");
        
        }
        else if (updatedPaymentOption == "plan") {
            $("#payment-options").find("#pay-plan").addClass("Tab--selected");
            $("#payment-options").find("#pay-now").removeClass("Tab--selected");
            $("#payment-options").find("#pay-plan").find("svg").addClass("p-TabIcon--selected");
            $("#payment-options").find("#pay-now").find("svg").removeClass("p-TabIcon--selected");
        }
        
        updateCheckout();
    }
    
    function updatePaymentMethodButton(updatedPaymentMethod) {
        if (updatedPaymentMethod == "ach") {
            $("#payment-methods").find("#ach").addClass("Tab--selected");
            $("#payment-methods").find("#card").removeClass("Tab--selected");
            $("#payment-methods").find("#ach").find("svg").addClass("p-TabIcon--selected");
            $("#payment-methods").find("#card").find("svg").removeClass("p-TabIcon--selected");
        }
        else if (updatedPaymentMethod == "card") {
            $("#payment-methods").find("#card").addClass("Tab--selected");
            $("#payment-methods").find("#ach").removeClass("Tab--selected");
            $("#payment-methods").find("#card").find("svg").addClass("p-TabIcon--selected");
            $("#payment-methods").find("#ach").find("svg").removeClass("p-TabIcon--selected");
        }
        
        updateCheckout();
    }
', View::POS_HEAD);

//$publishableKey = $model->environment === Stripe::LIVE ? $model->publishable_key : $model->test_publishable_key;
$publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);


?>
<script>
    function numberWithCommas(x) {
        return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    function format_number(n) {
        return n.toFixed(2).replace(/(\d)(?=(\d{3})+\.)/g, "$1,");
    }

    function updateCheckoutNumbers(subtotal) {
        // check which payment option was selected and which payment method was selected
        var paymentOption = $('#payment-options').find('.Tab--selected').find('.TabLabel').html();
        var paymentMethod = $('#payment-methods').find('.Tab--selected').find('.TabLabel').html();


        $('#checkout_subtotal').html('$' + format_number(subtotal));

        if (paymentOption == 'Pay Now') {
            var fees = Math.round(subtotal * 0.03 * 100) / 100;
            var discount = Math.round(subtotal * 0.02 * 100) / 100;

            <?= (!$model->surcharge ? 'fees=0;discount=0;' : '') ?>

            var grand_total = subtotal + fees;
            var discount_total = subtotal + fees - discount;

            $('#checkout_subtotal_row').show();
            $('#checkout_installments_row').hide();
            $('#checkout_individualpayment_row').hide();
            $('#checkout_fees').html('$' + format_number(fees));


            if (paymentMethod == 'ACH Transfer') {
                $('#checkout_discount').html('- $' + format_number(discount));
                $('#checkout_grand_total').html('$' + format_number(discount_total));

                $('#checkout_discount_row').show();
            }
            else if (paymentMethod == 'Card') {
                $('#checkout_grand_total').html('$' + format_number(grand_total));

                $('#checkout_discount_row').hide();
            }
        }
        else if (paymentOption == 'Pay in Installments') {
            var plan_subtotal = subtotal / 3;
            var plan_fees = Math.round(plan_subtotal * 0.035 * 100) / 100;
            var plan_discount = Math.round(plan_subtotal * 0.02 * 100) / 100;

            <?= (!$model->surcharge ? 'plan_fees=0;plan_discount=0;' : '') ?>

            var plan_grand_total = plan_subtotal + plan_fees;
            var plan_discount_total = plan_subtotal + plan_fees - plan_discount;

            $('#checkout_subtotal_row').hide();
            $('#checkout_installments_row').show();
            $('#checkout_installments').html("3 Equal Installments");
            $('#checkout_individualpayment_row').show();
            $('#checkout_individualpayment').html('$' + format_number(plan_subtotal));
            $('#checkout_fees').html('$' + format_number(plan_fees));


            if (paymentMethod == 'ACH Transfer') {
                $('#checkout_discount').html('- $' + format_number(plan_discount));
                $('#checkout_grand_total').html('$' + format_number(plan_discount_total));

                $('#checkout_discount_row').show();
            }
            else if (paymentMethod == 'Card') {
                $('#checkout_grand_total').html('$' + format_number(plan_grand_total));

                $('#checkout_discount_row').hide();
            }
        }
    }
</script>
<style>
    #switchBtn .button-strip {
        border: 1px solid gray;
        border-radius: 8px;
        display: inline-flex;
        overflow:hidden;
    }
    #paymentMethods .button-strip {
        display: inline-flex;
        overflow:hidden;
    }
    #switchBtn .strip-button, #paymentMethods .strip-button {
        background-color: white;
        color: gray;

        height: 100%;
        text-align: center;
        vertical-align: middle;

        transition: background-color .4s linear, color .2s linear;
        cursor: pointer;
        padding:6px;
        width:120px;
    }
    #paymentMethods .strip-button {
        width:150px;
    }
    #switchBtn .strip-button span, #paymentMethods .strip-button span {
        color: inherit;
    }
    #switchBtn .strip-button-text, #paymentMethods .strip-button-text  {
        font-size: 15px;
        color: gray;
        margin: 0px;
        padding: 0px;
    }
    #switchBtn .active-strip-button, #paymentMethods .active-strip-button {
        background-color: gray;
        color: white;
    }
    .card {
        padding:15px;
        width:160px;
        text-align:center;
        cursor:pointer;
    }
    .card svg {
        height:75px;
    }
    .card:hover, .card-selected {
        background-color:rgba(0, 0, 0, 0.1) !important;
    }
    #ach, #credit-card {
        width:100%;
    }
    #full-payment, #payment-plan {
        display:flex;
        flex-wrap:wrap;
        justify-content:center;
        width:500px;
    }
     .Tab {
         padding: var(--p-spacing3);
         background-color: var(--colorBackground);
         border-radius: var(--borderRadius);
         font-size: var(--fontSizeXs);
         font-weight: var(--fontWeightMedium);
         color: var(--colorTextSecondary);
         transition: background .15s ease, border .15s ease, box-shadow .15s ease;
         border: 1px solid var(--p-colorBackgroundDeemphasize10);
         box-shadow: 0px 1px 1px rgba(0, 0, 0, 0.03), 0px 3px 6px rgba(0, 0, 0, 0.02);
         flex-grow:1;
         width:50% !important;
     }
    .Tab--selected {
        border-color: var(--p-colorPrimary);
        color: var(--colorPrimary);
        box-shadow: 0px 1px 1px rgba(0, 0, 0, 0.03), 0px 3px 6px rgba(0, 0, 0, 0.02), 0 0 0 1px var(--colorPrimary);
    }
    .Icon {
        transition: fill 0.1s ease;
    }
    .p-TabIcon--selected, .p-TabIcon--selected path {
        fill: var(--colorIconTabSelected) !important;
        stroke: var(--colorIconTabSelected) !important;
    }
    .p-TabIcon {
        height: 1.2em;
        width: auto;
    }
    .p-PaymentMethodSelector {
        column-gap:8px;
        display:flex;
        width:100%;
        padding-bottom:20px;
    }
    .p-PaymentMethodSelector button {
        text-align:left;
    }
    .p-TabIconContainer {
        width:100%;
    }
    :root {
        --accessibleColorOnColorPrimary: #fff;
        --p-colorPrimaryHover: #0b81fa;
        --p-colorPrimaryActive: #228cfa;
        --p-colorPrimaryAlpha20: hsla(210, 96%, 45%, 25%);
        --p-colorPrimaryAlpha40: hsla(210, 96%, 45%, 40%);
        --p-colorPrimaryAlpha50: hsla(210, 96%, 45%, 50%);
        --p-colorPrimaryDisabled: #d9d9d9;
        --p-colorPrimaryDisabledText: #8d8d8d;
        --accessibleColorOnColorBackground: #30313d;
        --p-colorBackgroundDivider: #f2f2f2;
        --p-colorBackgroundDisabled: #f2f2f2;
        --p-colorBackgroundDisabledDeemphasize05: #e6e6e6;
        --p-colorBackgroundDeemphasize03: #f7f7f7;
        --p-colorBackgroundDeemphasize05: #f2f2f2;
        --p-colorBackgroundDeemphasize10: #e6e6e6;
        --p-colorBackgroundDeemphasize15: #d9d9d9;
        --p-colorBackgroundDeemphasize20: #cccccc;
        --p-colorBackgroundLightenAbsolute05: #ffffff;
        --p-colorBackgroundContrastAlpha05: rgba(0, 0, 0, 0.05);
        --p-colorBackgroundContrastAlpha08: rgba(0, 0, 0, 0.08);
        --p-colorBackgroundContrastAlpha30: rgba(0, 0, 0, 0.3);
        --colorTextSecondary: #6d6e78;
        --colorTextPlaceholder: #757680;
        --accessibleColorOnColorSuccess: #fff;
        --accessibleColorOnColorDanger: #fff;
        --accessibleColorOnColorWarning: #30313d;
        --p-linkProtectionsBadgeBackground: #1d3944;
        --p-linkProtectionsBadgeColor: #fff;
        --fontFamily: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, Cantarell, "Open Sans", "Helvetica Neue", sans-serif;
        --fontSmooth: always;
        --fontVariantLigatures: normal;
        --fontVariationSettings: normal;
        --fontLineHeight: 1.45;
        --fontSizeBase: 1rem;
        --fontSizeSm: 0.93rem;
        --fontSizeXs: 0.875rem;
        --fontSize2Xs: 0.8125rem;
        --fontSize3Xs: 0.75rem;
        --fontSizeLg: 1.0625rem;
        --fontSizeXl: 1.125rem;
        --fontSize2Xl: 1.25rem;
        --fontWeightLight: 300;
        --fontWeightNormal: 400;
        --fontWeightMedium: 600;
        --fontWeightBold: bold;
        --colorPrimary: #0570de;
        --colorBackground: #fff;
        --colorText: #30313d;
        --colorSuccess: #30b130;
        --colorDanger: #df1b41;
        --colorWarning: #f6e6b9;
        --iconColor: var(--colorTextSecondary);
        --iconHoverColor: var(--colorText);
        --iconCheckmarkColor: var(--colorPrimaryText);
        --iconCardErrorColor: var(--colorDanger);
        --iconCardCvcColor: var(--iconColor);
        --iconCardCvcErrorColor: var(--colorDanger);
        --iconChevronDownColor: var(--iconColor);
        --iconChevronDownHoverColor: var(--iconHoverColor);
        --iconCloseColor: var(--iconColor);
        --iconCloseHoverColor: var(--iconHoverColor);
        --iconLoadingIndicatorColor: var(--p-colorBackgroundContrastAlpha30);
        --iconMenuColor: var(--colorPrimary);
        --iconMenuHoverColor: var(--iconMenuColor);
        --iconMenuOpenColor: var(--iconMenuColor);
        --iconPasscodeDeviceColor: var(--iconColor);
        --iconPasscodeDeviceHoverColor: var(--iconHoverColor);
        --iconPasscodeDeviceNotificationColor: var(--colorPrimary);
        --iconRedirectColor: currentColor;
        --tabIconColor: var(--iconColor);
        --tabIconHoverColor: var(--colorText);
        --tabIconSelectedColor: var(--colorPrimary);
        --tabIconMoreColor: var(--iconColor);
        --tabIconMoreHoverColor: var(--colorText);
        --spacingUnit: 0.25rem;
        --gridRowSpacing: var(--p-spacing3);
        --gridColumnSpacing: var(--p-spacing3);
        --tabSpacing: var(--p-spacing1);
        --pickerItemSpacing: var(--p-spacing2);
        --accordionItemSpacing: var(--p-spacing2);
        --borderRadius: 5px;
        --focusBoxShadow: 0 0 0 3px var(--p-colorPrimaryAlpha20), 0 1px 1px 0 var(--p-colorBackgroundContrastAlpha08);
        --focusOutline: 0px;
        --spacingGridRow: var(--gridRowSpacing);
        --spacingGridColumn: var(--gridColumnSpacing);
        --spacingTab: var(--tabSpacing);
        --spacingPickerItem: var(--pickerItemSpacing);
        --spacingAccordionItem: var(--accordionItemSpacing);
        --colorPrimaryText: var(--accessibleColorOnColorPrimary);
        --colorBackgroundText: var(--accessibleColorOnColorBackground);
        --colorSuccessText: var(--accessibleColorOnColorSuccess);
        --colorDangerText: var(--accessibleColorOnColorDanger);
        --colorWarningText: var(--accessibleColorOnColorWarning);
        --colorIcon: var(--iconColor);
        --colorIconHover: var(--iconHoverColor);
        --colorIconCardError: var(--iconCardErrorColor);
        --colorIconCardCvc: var(--iconCardCvcColor);
        --colorIconCardCvcError: var(--iconCardCvcErrorColor);
        --colorIconCheckmark: var(--iconCheckmarkColor);
        --colorIconChevronDown: var(--iconChevronDownColor);
        --colorIconChevronDownHover: var(--iconChevronDownHoverColor);
        --colorIconClose: var(--iconCloseColor);
        --colorIconCloseHover: var(--iconCloseHoverColor);
        --colorIconLoadingIndicator: var(--iconLoadingIndicatorColor);
        --colorIconMenu: var(--iconMenuColor);
        --colorIconMenuHover: var(--iconMenuHoverColor);
        --colorIconMenuOpen: var(--iconMenuOpenColor);
        --colorIconPasscodeDevice: var(--iconPasscodeDeviceColor);
        --colorIconPasscodeDeviceHover: var(--iconPasscodeDeviceHoverColor);
        --colorIconPasscodeDeviceNotification: var(--iconPasscodeDeviceNotificationColor);
        --colorIconRedirect: var(--iconRedirectColor);
        --colorIconTab: var(--tabIconColor);
        --colorIconTabHover: var(--tabIconHoverColor);
        --colorIconTabSelected: var(--tabIconSelectedColor);
        --colorIconTabMore: var(--tabIconMoreColor);
        --colorIconTabMoreHover: var(--tabIconMoreHoverColor);
        --colorLogo: var(--logoColor);
        --colorLogoTab: var(--tabLogoColor);
        --colorLogoTabSelected: var(--tabLogoSelectedColor);
        --colorLogoBlock: var(--blockLogoColor);
        --p-spacingXs: 1px;
        --p-spacingSm: 2px;
        --p-spacing1: 0.25rem;
        --p-spacing2: 0.5rem;
        --p-spacing3: 0.75rem;
        --p-spacing4: 1rem;
        --p-spacing5: 1.25rem;
        --p-spacing6: 1.5rem;
        --p-spacing7: 1.75rem;
        --p-spacing8: 2rem;
        --p-spacing9: 2.25rem;
        --p-spacing10: 2.5rem;
        --logoColor: light;
        --p-logoLightDisplay: block;
        --p-logoDarkDisplay: none;
        --tabLogoColor: light;
        --p-logoTabLightDisplay: block;
        --p-logoTabDarkDisplay: none;
        --tabLogoSelectedColor: light;
        --p-logoTabSelectedLightDisplay: block;
        --p-logoTabSelectedDarkDisplay: none;
        --blockLogoColor: light;
        --p-logoBlockLightDisplay: block;
        --p-logoBlockDarkDisplay: none;
        -webkit-font-smoothing: antialiased;
        -moz-osx-font-smoothing: grayscale;
    }
</style>

    <div class="stripe-promo-form" style="display: flex;flex-wrap: wrap;justify-content: center;">

<!--        <div id="switchBtn" style="margin-bottom:20px;flex-basis: 100%;text-align: center;">-->
<!---->
<!--        </div>-->

        <div id="checkout-total" class="form-control" style="margin-bottom:20px;padding:0px;width:500px;">
            <div id="checkout_installments_row" style="display:flex;padding:20px;padding-bottom:0px;">
                <div style="display:inline-block;">Number of Installments</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_installments">3 Equal Installments</div>
            </div>
            <div id="checkout_individualpayment_row" style="display:flex;padding:20px;padding-bottom:0px;">
                <div style="display:inline-block;">Payment Amount</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_individualpayment"></div>
            </div>
            <div id="checkout_subtotal_row" style="display:flex;padding:20px;padding-bottom:0px;">
                <div style="display:inline-block;">Subtotal</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_subtotal">$0.00</div>
            </div>
            <?php if($model->surcharge) : ?>
                <div id="checkout_fees_row" style="display:flex;padding:20px;padding-bottom:0px;">
                    <div style="display:inline-block;">Fees</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_fees">$0.00</div>
                </div>
                <div id="checkout_discount_row" style="display:flex;padding:20px;padding-bottom:10px;">
                    <div style="display:inline-block;">Discount</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_discount">- $0.00</div>
                </div>
            <?php endif; ?>
            <div style="display:flex;border-top: 1px solid rgba(4, 32, 69, 0.14);padding:20px;margin-top:10px;">
                <div style="display:inline-block;font-weight:bold;">Total</div><div style="display:inline-block;font-weight:bold;flex-grow:1;text-align:right;" id="checkout_grand_total">$0.00</div>
                <input type="hidden" id="ach_amountSubTotal" value="0" />
                <input type="hidden" id="ach_amountTotal" value="0" />
            </div>
        </div>

        <div id="payment-options" style="margin-bottom:20px;padding:0px;width:500px;">
            <div style="flex-basis:100%;font-weight:bold;padding-bottom:20px;">
                Payment Options
            </div>

            <div role="tablist" aria-label="Payment Options" aria-orientation="horizontal" class="p-PaymentMethodSelector">
                <?php if(in_array('full', $model->payment_options)): ?>
                <button type="button" id="pay-now" class="p-Tab Tab <?= $model->payment_options[0] == 'full' ? 'Tab--selected' : '' ?>" onclick="updatePaymentOptionButton('full')">
                    <div class="p-TabIconContainer">
                        <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon  <?= $model->payment_options[0] == 'full' ? 'p-TabIcon--selected' : '' ?>" fill="#000000" viewBox="0 0 32 32" version="1.1" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M16 0c-8.836 0-16 7.163-16 16s7.163 16 16 16c8.837 0 16-7.163 16-16s-7.163-16-16-16zM16 30.032c-7.72 0-14-6.312-14-14.032s6.28-14 14-14 14 6.28 14 14-6.28 14.032-14 14.032zM22.386 10.146l-9.388 9.446-4.228-4.227c-0.39-0.39-1.024-0.39-1.415 0s-0.391 1.023 0 1.414l4.95 4.95c0.39 0.39 1.024 0.39 1.415 0 0.045-0.045 0.084-0.094 0.119-0.145l9.962-10.024c0.39-0.39 0.39-1.024 0-1.415s-1.024-0.39-1.415 0z"></path> </g></svg>
                    </div>
                    <span class="p-TabLabel TabLabel">Pay Now</span>

                </button>
                <?php endif; ?>
                <?php if(in_array('plan', $model->payment_options)): ?>
                <button type="button" id="pay-plan" class="p-Tab Tab <?= $model->payment_options[0] == 'plan' ? 'Tab--selected' : '' ?>" onclick="updatePaymentOptionButton('plan')">
                    <div class="p-TabIconContainer">
                        <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon  <?= $model->payment_options[0] == 'plan' ? 'p-TabIcon--selected' : '' ?>" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g id="Calendar / Calendar_Check"> <path id="Vector" d="M4 8H20M4 8V16.8002C4 17.9203 4 18.4801 4.21799 18.9079C4.40973 19.2842 4.71547 19.5905 5.0918 19.7822C5.5192 20 6.07899 20 7.19691 20H16.8031C17.921 20 18.48 20 18.9074 19.7822C19.2837 19.5905 19.5905 19.2842 19.7822 18.9079C20 18.4805 20 17.9215 20 16.8036V8M4 8V7.2002C4 6.08009 4 5.51962 4.21799 5.0918C4.40973 4.71547 4.71547 4.40973 5.0918 4.21799C5.51962 4 6.08009 4 7.2002 4H8M20 8V7.19691C20 6.07899 20 5.5192 19.7822 5.0918C19.5905 4.71547 19.2837 4.40973 18.9074 4.21799C18.4796 4 17.9203 4 16.8002 4H16M8 4H16M8 4V2M16 4V2M15 12L11 16L9 14" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g> </g></svg>
                    </div>
                    <span class="p-TabLabel TabLabel">Pay in Installments</span>
                </button>
                <?php endif; ?>
            </div>
        </div>

        <div id="payment-methods" style="margin-bottom:20px;padding:0px;width:500px;">
            <div style="flex-basis:100%;font-weight:bold;padding-bottom:20px;">
                Payment Methods
            </div>

            <div role="tablist" aria-label="Payment Methods" aria-orientation="horizontal" class="p-PaymentMethodSelector">
                <?php if(in_array('ach', $model->payment_methods)): ?>
                <button type="button" id="ach" class="p-Tab Tab <?= $model->payment_methods[0] == 'ach' ? 'Tab--selected' : '' ?>" onclick="updatePaymentMethodButton('ach')">
                    <div class="p-TabIconContainer">
                        <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon <?= $model->payment_methods[0] == 'ach' ? 'p-TabIcon--selected' : '' ?>"  viewBox="0 0 24 24" fill="var(--colorIcon)" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M3 21.0001H21M4 18.0001H20M6 18.0001V13.0001M10 18.0001V13.0001M14 18.0001V13.0001M18 18.0001V13.0001M12 7.00695L12.0074 7.00022M21 10.0001L14.126 3.88986C13.3737 3.2212 12.9976 2.88688 12.5732 2.75991C12.1992 2.64806 11.8008 2.64806 11.4268 2.75991C11.0024 2.88688 10.6263 3.2212 9.87404 3.88986L3 10.0001H21Z" stroke="var(--colorIcon)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
                    </div>
                    <span class="p-TabLabel TabLabel">ACH Transfer</span>

                </button>
                <?php endif; ?>

                <?php if(in_array('card', $model->payment_methods)): ?>
                <button type="button" id="card" class="p-Tab Tab <?= $model->payment_methods[0] == 'card' ? 'Tab--selected' : '' ?>" onclick="updatePaymentMethodButton('card')">
                    <div class="p-TabIconContainer">
                        <svg class="p-Icon p-Icon--card Icon p-Icon--md p-TabIcon TabIcon <?= $model->payment_methods[0] == 'card' ? 'p-TabIcon--selected' : '' ?>" role="presentation" fill="var(--colorIcon)" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><path fill-rule="evenodd" clip-rule="evenodd" d="M0 4a2 2 0 012-2h12a2 2 0 012 2H0zm0 2v6a2 2 0 002 2h12a2 2 0 002-2V6H0zm3 5a1 1 0 011-1h1a1 1 0 110 2H4a1 1 0 01-1-1z"></path></svg>
                    </div>
                    <span class="p-TabLabel TabLabel TabLabel--selected">Card</span>
                </button>
                <?php endif; ?>

            </div>
        </div>

        <div id="checkout" style="margin-bottom:20px;padding:0px;width:500px;">
            <div style="flex-basis:100%;font-weight:bold;padding-bottom:20px;">
                Checkout
            </div>
            <div id="full-ach">
                <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                    <div id="ach-payment-element" class=""></div>
                    <div id="card-errors" class="help-block error-block"></div>
                </div>
            </div>
            <div id="full-card" style="display:none;">
                <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                    <div id="payment-element" class=""></div>
                    <div id="card-errors" class="help-block error-block"></div>
                </div>
            </div>
            <div id="subscribe-ach" style="display:none;">
                <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                    <div id="subscription-ach-payment-element" class=""></div>
                    <div id="card-errors" class="help-block error-block"></div>
                </div>
            </div>
            <div id="subscribe-card" style="display:none;">
                <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
                    <div id="subscription-payment-element" class=""></div>
                    <div id="card-errors" class="help-block error-block"></div>
                </div>
            </div>
        </div>

    </div>


