<div style="display:flex;flex-wrap:wrap;justify-content:center;">
    <div id="checkout-total" class="form-control" style="width:400px;margin-bottom:20px;padding:0px;flex-basis:100%;">
        <div style="display:flex;padding:20px;padding-bottom:0px;">
            <div style="display:inline-block;">Subtotal</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_ach_subtotal"></div>
        </div>
        <div style="display:flex;padding:20px;padding-bottom:0px;">
            <div style="display:inline-block;">Fees</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_ach_fees"></div>
        </div>
        <div style="display:flex;padding:20px;padding-bottom:10px;">
            <div style="display:inline-block;">Discount</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_ach_discount">-$20.00</div>
        </div>
        <div style="display:flex;border-top: 1px solid rgba(4, 32, 69, 0.14);padding:20px;margin-top:10px;">
            <div style="display:inline-block;font-weight:bold;">Total</div><div style="display:inline-block;font-weight:bold;flex-grow:1;text-align:right;" id="checkout_ach_grand_total"></div>
            <input type="hidden" id="ach_amountSubTotal" value="0" />
            <input type="hidden" id="ach_amountTotal" value="0" />
        </div>
    </div>
    <div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
        <div id="ach-payment-element" class=""></div>
        <div id="card-errors" class="help-block error-block"></div>
    </div>
</div>

<script src="https://js.stripe.com/v3/"></script>
<script>

    $(document).ready(function(){
        var stripe = Stripe('{$publishableKey}');
        const options = {
            mode: 'payment',
            currency: 'usd',
            amount: 100,
            payment_method_types: [
                'us_bank_account',
            ],
        };
        var elements = stripe.elements(options);

        const paymentElement = elements.create("payment");
        paymentElement.mount("#ach-payment-element");

//    // Handle real-time validation errors from card Element.
//    card.addEventListener('change', function(event) {
//        var displayError = document.getElementById('card-errors');
//        if (displayError) {
//            if (event.error) {
//                $('#stripe-container').removeClass('has-error').addClass('has-error');
//                displayError.textContent = event.error.message;
//                isValidCard = false;
//            } else {
//                $('#stripe-container').removeClass('has-error');
//                displayError.textContent = '';
//                isValidCard = true;
//            }
//        }
//    });

        const handleSubmit = async (event) => {
            event.preventDefault();

            if (!stripe) {
                // Stripe.js hasn't yet loaded.
                // Make sure to disable form submission until Stripe.js has loaded.
                return;
            }

            // Trigger form validation and wallet collection
            const {error: submitError} = await elements.submit();
            if (submitError) {
                handleError(submitError);
                return;
            }

            const amount = $('#ach_amountTotal').val();
            const subTotalAmount = $('#ach_amountSubTotal').val();

            const result = await fetch("/create-intent.php", {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({
                    amountTotal: amount,
                    subTotal: subTotalAmount,
                    email: "sohaib12@gmail.com",
                }),
            }).then((r) => r.json());

            const clientSecret = result.clientSecret;

            try {
                const { error, paymentIntent } = await stripe.confirmPayment({
                    elements,
                    clientSecret,
                    confirmParams: {
                        return_url: "https://google.com",
                    },
                    redirect: "if_required",
                });

                if (error) {
                    console.error(error);
                    //handleError();
                } else if (paymentIntent && paymentIntent.status === "succeeded") {
                    console.log("Payment succeeded");

                    var hiddenInput = document.createElement('input');
                    hiddenInput.setAttribute('type', 'hidden');
                    hiddenInput.setAttribute('name', 'paymentIntent');
                    hiddenInput.setAttribute('value', paymentIntent.id);
                    formEl.find('[name="paymentIntent"]').remove();
                    formEl.append(hiddenInput);

                    // Submit form
                    formEl.submit();
                } else if (paymentIntent && paymentIntent.status === "processing") {
                    console.log("Payment Prcoessing");

                    var hiddenInput = document.createElement('input');
                    hiddenInput.setAttribute('type', 'hidden');
                    hiddenInput.setAttribute('name', 'paymentIntent');
                    hiddenInput.setAttribute('value', paymentIntent.id);
                    formEl.find('[name="paymentIntent"]').remove();
                    formEl.append(hiddenInput);

                    // Submit form
                    formEl.submit();
                } else {
                    console.log("Payment failed");
                    // handleOther();
                }
            } catch (error) {
                console.error(error);
            }

            return false;
        };


        $('button[type=submit]').on('click', handleSubmit);

    });
</script>
</body>