<?php

namespace app\modules\addons\modules\stripe\models;

use app\helpers\ArrayHelper;
use Yii;
use yii\helpers\Json;

/**
 * This is the model class for table "{{%addon_stripe_item}}".
 *
 * @property integer $id
 * @property integer $stripe_id
 * @property integer $form_id
 * @property string $description
 * @property string $quantity
 * @property string $price
 * @property string $amounts
 * @property string $icon
 */
class StripeItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_stripe_item}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'stripe_id'], 'integer'],
            [['description'], 'string', 'max' => 127],
            [['quantity', 'price', 'icon'], 'string', 'max' => 255],
            [['amounts'], 'string'],
            [['description', 'price', 'icon'], 'required']
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'stripe_id' => Yii::t('app', 'Stripe ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'description' => Yii::t('app', 'Description'),
            'quantity' => Yii::t('app', 'Quantity'),
            'price' => Yii::t('app', 'Price'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStripe()
    {
        return $this->hasOne(Stripe::class,['id'=>'stripe_id']);
    }

    /**
     * Return All Amounts for this Item.
     * @return array
     */
    public function getAmounts()
    {
        $amounts = Json::decode($this->amounts, true);
        return $amounts;
    }

    // id = radio_7_0
    public function getAmountForRadioField($id) {
        return $this->getAmounts()[$id];
    }
}
