<?php

namespace app\modules\addons\modules\stripe\models;

use app\helpers\ArrayHelper;
use app\modules\addons\modules\stripe\models\Stripe;
use Yii;
use yii\helpers\Json;

/**
 * This is the model class for table "{{%addon_stripe_coupon}}".
 *
 * @property integer $id
 * @property integer $stripe_id
 * @property integer $form_id
 * @property string $description
 * @property string $code
 * @property integer $price
 */
class StripeCoupon extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_stripe_coupon}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'stripe_id', 'price'], 'integer'],
            [['description', 'code'], 'string', 'max' => 127],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'stripe_id' => Yii::t('app', 'Stripe ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'description' => Yii::t('app', 'Description'),
            'code' => Yii::t('app', 'Promo Code'),
            'price' => Yii::t('app', 'Price'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getStripe()
    {
        return $this->hasOne(Stripe::class,['id'=>'stripe_id']);
    }
}
