<?php
namespace app\modules\stripe\helpers;

use app\helpers\Html;
use app\modules\addons\modules\stripe\models\Stripe;
use Yii;
use yii\helpers\Url;

class ClientBackup
{

    public static function paymentMethodTypes()
    {
        return [
            'card' => Yii::t('app', 'Card'),
            'acss_debit' => Yii::t('app', 'Canadian pre-authorized debit'),
            'afterpay_clearpay' => Yii::t('app', 'Afterpay and Clearpay'),
            'alipay' => Yii::t('app', 'Alipay'),
            'bacs_debit' => Yii::t('app', 'Bacs Direct Debit'),
            'bancontact' => Yii::t('app', 'Bancontact'),
            'boleto' => Yii::t('app', 'Boleto'),
            'eps' => Yii::t('app', 'EPS'),
            'fpx' => Yii::t('app', 'FPX'),
            'giropay' => Yii::t('app', 'giropay'),
            'grabpay' => Yii::t('app', 'GrabPay'),
            'ideal' => Yii::t('app', 'iDEAL'),
            'klarna' => Yii::t('app', 'Klarna'),
            'oxxo' => Yii::t('app', 'OXXO'),
            'p24' => Yii::t('app', 'Przelewy24'),
            'sepa_debit' => Yii::t('app', 'SEPA Direct Debit'),
            'sofort' => Yii::t('app', 'Sofort'),
            'wechat_pay' => Yii::t('app', 'WeChat Pay'),
        ];
    }

    /**
     * @param $event
     * @param $model Stripe
     * @return void
     */
    public static function displayCheckoutCodeOnView($event, $model)
    {
//        $publishableKey = $model->environment === Stripe::LIVE ? $model->publishable_key : $model->test_publishable_key;
        $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);

        $jsCode = <<<EOT

<script src="https://js.stripe.com/v3/"></script>
<script>
$(document).ready(function(){
    formEl.on('success', function(event, data){
        if (typeof data.addons !== 'undefined') {
            if (typeof data.addons.stripe !== 'undefined') {
                if (typeof data.addons.stripe.session_id !== 'undefined') {
                    var stripe = Stripe('{$publishableKey}');
                    stripe
                    .redirectToCheckout({
                      sessionId: data.addons.stripe.session_id
                    })
                    .then(function(result) {
                      console.log("error", result);
                      if (typeof result.error !== 'undefined') {
                        if (typeof result.error.message !== 'undefined') {
                          alert(result.error.message);                    
                        }                  
                      }
                    })
                    .catch(function(err) {
                      console.log(err);
                    });
                }
            }
        }
    });
})
</script>
</body>
EOT;

        $content = $event->output;
        $event->output = str_replace("</body>", $jsCode, $content);
    }

    /**
     * @param $event
     * @param $model Stripe
     * @return void
     */
    public static function displayCreditCardCodeOnView($event, $model)
    {
        $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);
        $connected_account_id = Yii::$app->user->identity->stripe_account_id;


        // Required
        $required = $model->required ? 'true' : 'false';
        $requiredCssClass = $model->required ? 'required-control' : '';

        // Label
        $label = empty($model->label) ? Yii::t('app', 'Credit or debit card') : $model->label;
        $label = Html::label($label, 'stripe', ['class' => 'control-label stripe-card-label']);

//        // HTML Code
//        $content = <<<HTML
//<div style="display:flex;flex-wrap:wrap;justify-content:center;">
//<div id="checkout-total" class="form-control" style="width:400px;margin-bottom:20px;padding:0px;flex-basis:100%;">
//    <div style="display:flex;padding:20px;padding-bottom:0px;">
//        <div style="display:inline-block;">Subtotal</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_subtotal"></div>
//    </div>
//    <div style="display:flex;padding:20px;padding-bottom:10px;">
//        <div style="display:inline-block;">Fees</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_fees"></div>
//    </div>
//    <div style="display:flex;border-top: 1px solid rgba(4, 32, 69, 0.14);padding:20px;margin-top:10px;">
//        <div style="display:inline-block;font-weight:bold;">Total</div><div style="display:inline-block;font-weight:bold;flex-grow:1;text-align:right;" id="checkout_grand_total"></div>
//        <input type="hidden" id="amountSubTotal" value="0" />
//        <input type="hidden" id="amountTotal" value="0" />
//    </div>
//</div>
//<div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
//    <div id="payment-element" class=""></div>
//    <div id="card-errors" class="help-block error-block"></div>
//</div>
//</div>
//<!-- Modal -->
//<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
//  <div class="modal-dialog modal-dialog-centered" role="document">
//    <div class="modal-content">
//      <div class="modal-header">
//        <h5 class="modal-title" id="exampleModalLongTitle">Modal title</h5>
//        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
//          <span aria-hidden="true">&times;</span>
//        </button>
//      </div>
//      <div class="modal-body">
//        ...
//      </div>
//      <div class="modal-footer">
//        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
//        <button type="button" class="btn btn-primary">Save changes</button>
//      </div>
//    </div>
//  </div>
//</div>
//HTML;
//
//        $htmlCode = $content;

        $jsCode = <<<EOT
<!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">-->
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<script src="https://js.stripe.com/v3/"></script>
<script>
   
    
$(document).ready(function(){
    var stripe = Stripe('{$publishableKey}');
    const options = {
      mode: 'payment',
      currency: 'usd',
      amount: 100,
      payment_method_types: [
           'card',
       ],
    };
    var elements = stripe.elements(options);
    
    const paymentElement = elements.create("payment");
    paymentElement.mount("#payment-element");
    
    var isValidCard = false;

//    // Handle real-time validation errors from card Element.
//    card.addEventListener('change', function(event) {
//        var displayError = document.getElementById('card-errors');
//        if (displayError) {
//            if (event.error) {
//                $('#stripe-container').removeClass('has-error').addClass('has-error');
//                displayError.textContent = event.error.message;
//                isValidCard = false;
//            } else {
//                $('#stripe-container').removeClass('has-error');
//                displayError.textContent = '';
//                isValidCard = true;
//            }
//        }
//    });

    const handleSubmit = async (event) => {
        event.preventDefault();
        
        // $('#myModal').modal({
        //     backdrop: 'static',
        //     keyboard: false  // to prevent closing with Esc button (if you want this too)
        // });
        // return;
        
        if (!stripe) {
            // Stripe.js hasn't yet loaded.
            // Make sure to disable form submission until Stripe.js has loaded.
            return;
        }
        
        // Trigger form validation and wallet collection
        const {error: submitError} = await elements.submit();
        if (submitError) {
            console.log("Payment Not Filled Out");
            
            if ({$required}) {
                handleError(submitError);
                return;
            }
            else {
                console.log("Payment Not Filled & Not Required");
                formEl.submit();
                return;
            }
        }
        
        const amount = $('#amountTotal').val();
        const subTotalAmount = $('#amountSubTotal').val();
        
        const result = await fetch("/create-intent.php", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({
            amountTotal: amount,
            subTotal: subTotalAmount,
            email: "sohaib12@gmail.com",
            connected_account_id: "{$connected_account_id}"
          }),
        }).then((r) => r.json());
        
        const clientSecret = result.clientSecret;
        
        try {
              const { error, paymentIntent } = await stripe.confirmPayment({
                elements,
                clientSecret,
                confirmParams: {
                  return_url: "https://google.com",
                },
                redirect: "if_required",
              });
              
              if (error) {
                console.error(error);
                //handleError();
              } else if (paymentIntent && paymentIntent.status === "succeeded") {
                console.log("Payment succeeded");
                // handleSuccess();
                
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
                
              } else {
                console.log("Payment failed");
                // handleOther();
              }
        } catch (error) {
            console.error(error);
        }
        
        return false;
    };


    $('button[type=submit]').on('click', handleSubmit); 

//    // Handle submit button
//    $('button[type=submit]').on('click', function(event){
//        if (isValidCard  || {$required}) {
//            event.preventDefault();
//            stripe.createToken(card).then(function(result) {
//                if (result.error) {
//                    var errorElement = document.getElementById('card-errors');
//                    errorElement.textContent = result.error.message;
//                } else {
//                    // Send token to your server
//                    stripeTokenHandler(result.token);
//                }
//            });   
//            return false;
//        }
//    });

//    formEl.on('success', function(event){ FIX
//        // Clear CC fields
//        card.clear();
//    });

});
</script>
</body>
EOT;

        $content = $event->output;
//        $content = str_replace("{{STRIPE}}", $htmlCode, $content);

        if (str_contains($content, '{{STRIPE-PROMO}}')) {
            $rendered = Yii::$app->view->render('@app/modules/addons/modules/stripe/views/admin/_promo', ['id' => $model->id, 'model' => $model]);

            $content = str_replace("{{STRIPE-PROMO}}", $rendered, $content);
        }
//        $model->render('admin/_promo', []);
//        $model->render('@app/modules/addons/modules/stripe/views/admin/_promo');
//        $model->render('@app/themes/next/views/partials/_breadcrumbs');



        $event->output = str_replace("</body>", $jsCode, $content);

    }


    /**
     * @param $event
     * @param $model Stripe
     * @return void
     */
    public static function displayACHCodeOnView($event, $model)
    {

        $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);
        $connected_account_id = Yii::$app->user->identity->stripe_account_id;

        // Required
        $required = $model->required ? 'true' : 'false';
        $requiredCssClass = $model->required ? 'required-control' : '';

        // Label
        $label = empty($model->label) ? Yii::t('app', 'Credit or debit card') : $model->label;
        $label = Html::label($label, 'stripe', ['class' => 'control-label stripe-card-label']);

        // HTML Code
//        $content = <<<HTML
//<div style="display:flex;flex-wrap:wrap;justify-content:center;">
//<div id="checkout-total" class="form-control" style="width:400px;margin-bottom:20px;padding:0px;flex-basis:100%;">
//    <div style="display:flex;padding:20px;padding-bottom:0px;">
//        <div style="display:inline-block;">Subtotal</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_ach_subtotal"></div>
//    </div>
//    <div style="display:flex;padding:20px;padding-bottom:0px;">
//        <div style="display:inline-block;">Fees</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_ach_fees"></div>
//    </div>
//    <div style="display:flex;padding:20px;padding-bottom:10px;">
//        <div style="display:inline-block;">Discount</div><div style="display:inline-block;flex-grow:1;text-align:right;" id="checkout_ach_discount">-$20.00</div>
//    </div>
//    <div style="display:flex;border-top: 1px solid rgba(4, 32, 69, 0.14);padding:20px;margin-top:10px;">
//        <div style="display:inline-block;font-weight:bold;">Total</div><div style="display:inline-block;font-weight:bold;flex-grow:1;text-align:right;" id="checkout_ach_grand_total"></div>
//        <input type="hidden" id="ach_amountSubTotal" value="0" />
//        <input type="hidden" id="ach_amountTotal" value="0" />
//    </div>
//</div>
//<div id="stripe-container" class="form-group {$requiredCssClass}" style="flex-basis:100%;">
//    <div id="ach-payment-element" class=""></div>
//    <div id="card-errors" class="help-block error-block"></div>
//</div>
//</div>
//HTML;
//
//        $htmlCode = $content;

        $jsCode = <<<EOT

<script src="https://js.stripe.com/v3/"></script>
<script>

$(document).ready(function(){
    var stripe = Stripe('{$publishableKey}');
    const options = {
      mode: 'payment',
      currency: 'usd',
      amount: 100,
      payment_method_types: [
           'us_bank_account',
       ],
    };
    var elements = stripe.elements(options);
    
    const paymentElement = elements.create("payment");
    paymentElement.mount("#ach-payment-element");
    
//    // Handle real-time validation errors from card Element.
//    card.addEventListener('change', function(event) {
//        var displayError = document.getElementById('card-errors');
//        if (displayError) {
//            if (event.error) {
//                $('#stripe-container').removeClass('has-error').addClass('has-error');
//                displayError.textContent = event.error.message;
//                isValidCard = false;
//            } else {
//                $('#stripe-container').removeClass('has-error');
//                displayError.textContent = '';
//                isValidCard = true;
//            }
//        }
//    });

    const handleSubmit = async (event) => {
        event.preventDefault();
        
        if (!stripe) {
            // Stripe.js hasn't yet loaded.
            // Make sure to disable form submission until Stripe.js has loaded.
            return;
        }
        
        // Trigger form validation and wallet collection
        const {error: submitError} = await elements.submit();
        if (submitError) {
            console.log("Payment Not Filled Out");
            
            if ({$required}) {
                handleError(submitError);
                return;
            }
            else {
                console.log("Payment Not Filled & Not Required");
                formEl.submit();
                return;
            }
        }
        
        const amount = $('#ach_amountTotal').val();
        const subTotalAmount = $('#ach_amountSubTotal').val();
        
        const result = await fetch("/create-intent.php", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({
            amountTotal: amount,
            subTotal: subTotalAmount,
            email: "sohaib12@gmail.com",
            connected_account_id: "{$connected_account_id}"

          }),
        }).then((r) => r.json());
        
        const clientSecret = result.clientSecret;
        
        try {
              const { error, paymentIntent } = await stripe.confirmPayment({
                elements,
                clientSecret,
                confirmParams: {
                  return_url: "https://google.com",
                },
                redirect: "if_required",
              });
              
              if (error) {
                console.error(error);
                //handleError();
              } else if (paymentIntent && paymentIntent.status === "succeeded") {
                console.log("Payment succeeded");
                
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
              } else if (paymentIntent && paymentIntent.status === "processing") {
                console.log("Payment Prcoessing");
                  
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                  
                // Submit form
                formEl.submit();
              } else {
                console.log("Payment failed");
                // handleOther();
              }
        } catch (error) {
            console.error(error);
        }
        
        return false;
    };


    $('button[type=submit]').on('click', handleSubmit); 

});
</script>
</body>
EOT;

        $content = $event->output;

//        $content = str_replace("{{ACH-STRIPE}}", $htmlCode, $content);

        if (str_contains($content, '{{STRIPE-PROMO}}')) {
            $rendered = Yii::$app->view->render('@app/modules/addons/modules/stripe/views/admin/_promo', ['id' => $model->id, 'model' => $model]);

            $content = str_replace("{{STRIPE-PROMO}}", $rendered, $content);
        }

        $checkoutCode = '<div id="replace_with_checkout" style="display:flex;justify-content:center;align-items:center;padding:20px;">This field will enable users to checkout and pay.</div>';
        if (str_contains($content, $checkoutCode)) {
            $rendered = Yii::$app->view->render('@app/modules/addons/modules/stripe/views/admin/_checkout', ['id' => $model->id, 'model' => $model]);

            $content = str_replace($checkoutCode, $rendered, $content);
        }


        $event->output = str_replace("</body>", $jsCode, $content);

    }

    public static function displaySubscribeCreditCard($event, $model)
    {

        $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);
        $connected_account_id = Yii::$app->user->identity->stripe_account_id;

        // Required
        $required = $model->required ? 'true' : 'false';
        $requiredCssClass = $model->required ? 'required-control' : '';


        $jsCode = <<<EOT

<script src="https://js.stripe.com/v3/"></script>
<script>

$(document).ready(function(){
    var stripe = Stripe('{$publishableKey}');
    const options = {
      mode: 'subscription',
      currency: 'usd',
      amount: 100,
      payment_method_types: [
           'card',
       ],
    };
    var elements = stripe.elements(options);
    
    const paymentElement = elements.create("payment");
    paymentElement.mount("#subscription-payment-element");

    const handleSubmit = async (event) => {
        event.preventDefault();
        
        if (!stripe) {
            // Stripe.js hasn't yet loaded.
            // Make sure to disable form submission until Stripe.js has loaded.
            return;
        }
        
        // Trigger form validation and wallet collection
        const {error: submitError} = await elements.submit();
        if (submitError) {
            console.log("Payment Not Filled Out");
            
            if ({$required}) {
                handleError(submitError);
                return;
            }
            else {
                console.log("Payment Not Filled & Not Required");
                formEl.submit();
                return;
            }
        }
        
        const amount = $('#ach_amountTotal').val();
        const subTotalAmount = $('#ach_amountSubTotal').val();
        
        const result = await fetch("/create-subscription.php", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({
            amountTotal: amount,
            subTotal: subTotalAmount,
            email: "sohaib12@gmail.com",
            connected_account_id: "{$connected_account_id}"
          }),
        }).then((r) => r.json());
        
        const clientSecret = result.clientSecret;
        
        try {
              const { error, paymentIntent } = await stripe.confirmPayment({
                elements,
                clientSecret,
                confirmParams: {
                  return_url: "https://google.com",
                },
                redirect: "if_required",
              });
              
              if (error) {
                console.error(error);
                //handleError();
              } else if (paymentIntent && paymentIntent.status === "succeeded") {
                console.log("Payment succeeded");
                
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
              } else if (paymentIntent && paymentIntent.status === "processing") {
                console.log("Payment Prcoessing");
                  
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                  
                // Submit form
                formEl.submit();
              } else {
                console.log("Payment failed");
                // handleOther();
              }
        } catch (error) {
            console.error(error);
        }
        
        return false;
    };


    $('button[type=submit]').on('click', handleSubmit); 

});
</script>
</body>
EOT;

        $content = $event->output;

        $event->output = str_replace("</body>", $jsCode, $content);

    }

    public static function displaySubscribeACH($event, $model)
    {
        $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);
        $connected_account_id = Yii::$app->user->identity->stripe_account_id;

        // Required
        $required = $model->required ? 'true' : 'false';
        $requiredCssClass = $model->required ? 'required-control' : '';

        $jsCode = <<<EOT

<script src="https://js.stripe.com/v3/"></script>
<script>

$(document).ready(function(){
    var stripe = Stripe('{$publishableKey}');
    const options = {
      mode: 'subscription',
      currency: 'usd',
      amount: 100,
      payment_method_types: [
           'us_bank_account',
       ],
    };
    var elements = stripe.elements(options);
    
    const paymentElement = elements.create("payment");
    paymentElement.mount("#subscription-ach-payment-element");

    const handleSubmit = async (event) => {
        event.preventDefault();
        
        if (!stripe) {
            // Stripe.js hasn't yet loaded.
            // Make sure to disable form submission until Stripe.js has loaded.
            return;
        }
        
        // Trigger form validation and wallet collection
        const {error: submitError} = await elements.submit();
        if (submitError) {
            console.log("Payment Not Filled Out");
            
            if ({$required}) {
                handleError(submitError);
                return;
            }
            else {
                console.log("Payment Not Filled & Not Required");
                formEl.submit();
                return;
            }
        }
        
        const amount = $('#ach_amountTotal').val();
        const subTotalAmount = $('#ach_amountSubTotal').val();
        
        const result = await fetch("/create-subscription.php", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({
            amountTotal: amount,
            subTotal: subTotalAmount,
            email: "sohaib12@gmail.com",
            connected_account_id: "{$connected_account_id}"
          }),
        }).then((r) => r.json());
        
        const clientSecret = result.clientSecret;
        
        try {
              const { error, paymentIntent } = await stripe.confirmPayment({
                elements,
                clientSecret,
                confirmParams: {
                  return_url: "https://google.com",
                },
                redirect: "if_required",
              });
              
              if (error) {
                console.error(error);
                //handleError();
              } else if (paymentIntent && paymentIntent.status === "succeeded") {
                console.log("Payment succeeded");
                
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
              } else if (paymentIntent && paymentIntent.status === "processing") {
                console.log("Payment Prcoessing");
                  
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                  
                // Submit form
                formEl.submit();
              } else {
                console.log("Payment failed");
                // handleOther();
              }
        } catch (error) {
            console.error(error);
        }
        
        return false;
    };


    $('button[type=submit]').on('click', handleSubmit); 

});
</script>
</body>
EOT;

        $content = $event->output;

        $event->output = str_replace("</body>", $jsCode, $content);

    }

    /**
     * Return parameters for Stripe Checkout
     *
     * @param $model
     * @param $formModel
     * @param $submissionModel
     * @param $submissionData
     * @param $stripeService
     * @return array
     */
    public static function generateCheckoutParameters($model, $formModel, $submissionModel, $submissionData, $stripeService)
    {
        $i = 0;
        $items = [];
        $metadata = [
            'app' => Yii::$app->name,
            'form_id' => $formModel->id,
            'submission_id' => $submissionModel->id,
        ];

        // Add User ID to Metadata
        if (!Yii::$app->user->isGuest) {
            $metadata['user_id'] = Yii::$app->user->id;
        }

        $currency = !empty($model->currency) ? $model->currency : 'usd';
        if (!empty($model->currency) && !empty($submissionData[$model->currency])) {
            $currency = is_array($submissionData[$model->currency]) ? implode('', $submissionData[$model->currency]) : $submissionData[$model->currency];
        }
        $successUrl = Url::to(['/addons/stripe/check/payment', 'id' => $model->id, 'form_id' => $formModel->id, 'submission_id' => $submissionModel->id], true);
        $successUrl = $successUrl . "&session_id={CHECKOUT_SESSION_ID}";

        $params = [
            'mode' => 'payment',
            'success_url' => $successUrl,
            'cancel_url' => $model->cancel_url,
        ];

        // Payment method types
        if (!empty($model->payment_method_types)) {
            $params['payment_method_types'] = $model->payment_method_types;
        }

        // Customer ID
        if (!empty($model->receipt_email) && !empty($submissionData[$model->receipt_email])) {
            $email = is_array($submissionData[$model->receipt_email]) && !empty($submissionData[$model->receipt_email][0]) ? $submissionData[$model->receipt_email][0] : $submissionData[$model->receipt_email];
            $customerID = $stripeService->findCustomerIdBy([
                'email' => $email,
            ]);
            if (empty($customerID)) {
                $params['customer_email'] = $email;
            } else {
                $params['customer'] = $customerID;
            }
        }

        // Billing Address
        if ($model->billing_address) {
            $params['billing_address_collection'] = 'required';
        }

        // Subscription
        if ($model->checkout && $model->subscription) {

            // Trial period
            if ($model->trial && $model->trial_days > 0) {
                $params['subscription_data']['trial_period_days'] = $model->trial_days;
            }

            foreach ($model->items as $itemModel) {
                // Check field value
                $quantity = isset($itemModel->quantity, $submissionData[$itemModel->quantity]) &&
                !empty($submissionData[$itemModel->quantity]) ?
                    $submissionData[$itemModel->quantity] : 1;
                $quantity = is_array($quantity) ? array_sum($quantity) : $quantity;
                $price = isset($itemModel->price, $submissionData[$itemModel->price]) &&
                !empty($submissionData[$itemModel->price]) ?
                    $submissionData[$itemModel->price] : '';
                // Array of pricing plans
                $price = is_array($price) ? $price : explode(',', $price);
                foreach ($price as $price_id) {
                    if (!empty($price_id)) {
                        array_push($items, [
                            'price' => $price_id,
                            'quantity' => $quantity,
                        ]);
                        $metadata['item_' . ++$i] = 'Description: ' . $itemModel->description . ' - Price ID: ' . $price_id . ' - Quantity: ' . $quantity;
                    }
                }
            }

            $params['mode'] = 'subscription';
            $params['line_items'] = $items;
            $params['subscription_data'] = [
                'metadata' => $metadata,
            ];

        } else { // One-Time Payment

            // Line Items
            foreach ($model->items as $itemModel) {
                // Check field value
                $quantity = isset($itemModel->quantity, $submissionData[$itemModel->quantity]) &&
                !empty($submissionData[$itemModel->quantity]) ?
                    $submissionData[$itemModel->quantity] : 1;
                $price = isset($itemModel->price, $submissionData[$itemModel->price]) &&
                !empty($submissionData[$itemModel->price]) ?
                    $submissionData[$itemModel->price] : 0;

                // Sum values if field value is an array
                $quantity = is_array($quantity) ? array_sum($quantity) : $quantity;
                $price = is_array($price) ? array_sum($price) : $price;

                array_push($items, [
                    'price_data' => [
                        'currency' => $currency,
                        'product_data' => [
                            'name' => $itemModel->description,
                        ],
                        'unit_amount' => $price * 100, // Stripe Accepts Charges In Cents
                    ],
                    'quantity' => $quantity,
                ]);

                $metadata['item_' . ++$i] = 'Description: ' . $itemModel->description . ' - Price: ' . number_format($price, 2) . ' - Quantity: ' . $quantity . ' - SubTotal: ' . number_format( $quantity * $price, 2);
            }

            $params['line_items'] = $items;
            $params['payment_intent_data'] = [
                'metadata' => $metadata,
            ];
        }

        return $params;
    }
}