<?php
namespace app\modules\addons\modules\stripe\helpers;

use app\helpers\Html;
use app\models\Form;
use app\modules\addons\modules\stripe\models\Stripe;
use Yii;
use yii\helpers\Url;
use yii\web\IdentityInterface;
use yii\web\User;

class Client
{

    public static function paymentMethodTypes()
    {
        return [
            'card' => Yii::t('app', 'Card'),
            'acss_debit' => Yii::t('app', 'Canadian pre-authorized debit'),
            'afterpay_clearpay' => Yii::t('app', 'Afterpay and Clearpay'),
            'alipay' => Yii::t('app', 'Alipay'),
            'bacs_debit' => Yii::t('app', 'Bacs Direct Debit'),
            'bancontact' => Yii::t('app', 'Bancontact'),
            'boleto' => Yii::t('app', 'Boleto'),
            'eps' => Yii::t('app', 'EPS'),
            'fpx' => Yii::t('app', 'FPX'),
            'giropay' => Yii::t('app', 'giropay'),
            'grabpay' => Yii::t('app', 'GrabPay'),
            'ideal' => Yii::t('app', 'iDEAL'),
            'klarna' => Yii::t('app', 'Klarna'),
            'oxxo' => Yii::t('app', 'OXXO'),
            'p24' => Yii::t('app', 'Przelewy24'),
            'sepa_debit' => Yii::t('app', 'SEPA Direct Debit'),
            'sofort' => Yii::t('app', 'Sofort'),
            'wechat_pay' => Yii::t('app', 'WeChat Pay'),
        ];
    }


    public static function displayCheckout($event, Stripe $model)
    {
        $content = $event->output;

//        if (str_contains($content, '{{STRIPE-PROMO}}')) {
//            $rendered = Yii::$app->view->render('@app/modules/addons/modules/stripe/views/admin/_promo', ['id' => $model->id, 'model' => $model]);
//
//            $content = str_replace("{{STRIPE-PROMO}}", $rendered, $content);
//        }

//        $formModel = Form::findOne(['id' => $model->form_id]);

        $checkoutCode = '<div id="replace_with_checkout" style="display:flex;justify-content:center;align-items:center;padding:20px;">This field will enable users to checkout and pay.</div>';
        if (str_contains($content, $checkoutCode)) {
            $rendered = Yii::$app->view->render('@app/modules/addons/modules/stripe/views/admin/_checkout2', ['model' => $model]);

            $content = str_replace($checkoutCode, $rendered, $content);
        }

        $event->output = $content;

        Client::displayCreditCardCodeOnView($event, $model);
        Client::displayACHCodeOnView($event, $model);
        Client::displaySubscribeCreditCard($event, $model);
        Client::displaySubscribeACH($event, $model);
    }

    /**
     * @param $event
     * @param $model Stripe
     * @return void
     */
    public static function displayCreditCardCodeOnView($event, Stripe $model, $connected_account_id = null)
    {
        $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);
//        $connected_account_id = Yii::$app->user->identity->stripe_account_id;

        //$formModel = Form::findOne(['id' => $model->form_id]);

        if (empty($connected_account_id)) {
            $user = \app\models\User::findIdentity($model->form->created_by);
            $connected_account_id = $user->stripe_account_id;
        }

        // Required
        $required = $model->required ? 'true' : 'false';
        $requiredCssClass = $model->required ? 'required-control' : '';

        $customPercentage = !empty($model->fee_percentage) ? 'true' : 'false';

        // Label
        $label = empty($model->label) ? Yii::t('app', 'Credit or debit card') : $model->label;
        $label = Html::label($label, 'stripe', ['class' => 'control-label stripe-card-label']);

        $cardholder_name = $model->cardholder_name;
        $receipt_email = $model->receipt_email;
        $description = $model->description;
        $statement_descriptor = $model->statement_descriptor;

        $cardholderNotEmpty = !empty($cardholder_name) ? 'true' : 'false';
        $emailNotEmpty = !empty($receipt_email) ? 'true' : 'false';

        $jsCode = <<<EOT
<!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">-->
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<script>
   
    
$(document).ready(function(){
    var stripe = Stripe('{$publishableKey}');
    const options = {
      mode: 'payment',
      currency: 'usd',
      amount: 100,
      payment_method_types: [
           'card',
       ],
    };
    var elements = stripe.elements(options);
    
    const paymentElement = elements.create("payment", {
              defaultValues: {
                billingDetails: {
                  name: $('input[name={$cardholder_name}]').val(),
                  email: $('input[name={$receipt_email}]').val()
                }
              }
            });
    paymentElement.mount("#payment-element");
    
    if ({$cardholderNotEmpty}) {            
        
        $('input[name={$cardholder_name}]').on('change',function(e){
            var paymentElement = elements.getElement('payment');
            
            // Update with modified defaultValues
            paymentElement.update({
              defaultValues: {
                billingDetails: {
                  name: $(this).val()
                }
              }
            });
        });
    }
    
    if ({$emailNotEmpty}) {
        
        $('input[name={$receipt_email}]').on('change',function(e){
            var paymentElement = elements.getElement('payment');
            
            // Update with modified defaultValues
            paymentElement.update({
              defaultValues: {
                billingDetails: {
                  email: $(this).val()
                }
              }
            });
        });
    }
    
    var isValidCard = false;

    const handleSubmit = async (event) => {
        event.preventDefault();
        
        if (!stripe) {
            return;
        }
        
        clearError();
        
        console.log($("#full-card").css("max-height"));
        if ($("#full-card").css("max-height") == '0px')
            return;
        
        // Trigger form validation and wallet collection
        const {error: submitError} = await elements.submit();
        if (submitError) {
            console.log("Payment Not Filled Out");
            
            if ({$required}) {
                handleError(submitError);
                return;
            }
            else {
                console.log("Payment Not Filled & Not Required");
                formEl.submit();
                return;
            }
        }
        
        $("input[name=payment_type]").val("full");
        
        const amount = $('#amountTotal').val();
        const subTotalAmount = $('#amountSubTotal').val();
        const amountTransfer = ({$customPercentage} ? bigDecimal.round(bigDecimal.multiply($('#amountTotal').val(), 0.97)) : subTotalAmount);
        const fullname = $('input[name="{$cardholder_name}"]').val(); 
        const email = $('input[name="{$receipt_email}"]').val();
        
        const result = await fetch("/create-intent.php", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({
            amountTotal: amount,
            subTotal: subTotalAmount,
            amountTransfer: amountTransfer,
            email: email,
            fullname: fullname,
            description: '{$description}',
            statement_descriptor: '{$statement_descriptor}',
            connected_account_id: "{$connected_account_id}",
            currency: "usd",
            paymentMethod: "card",
          }),
        }).then((r) => r.json());
        
        const clientSecret = result.clientSecret;
        
        try {
              const { error, paymentIntent } = await stripe.confirmPayment({
                elements,
                clientSecret,
                // confirmParams: {
                //   return_url: "https://google.com",
                // },
                redirect: "if_required",
              });
              
              if (error) {
                console.error(error);
                handleError();
              } else if (paymentIntent && paymentIntent.status === "succeeded") {
                console.log("Payment succeeded");
                handleSuccess();
                
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
              } else if (paymentIntent && paymentIntent.status === "requires_action") {
                console.log("Payment Requires Action");
                handleRequiresAction();
                  
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                  
                // Submit form
                formEl.submit();
              } else {
                  console.log(result);
                console.log("Payment failed");
                handleError();
              }
        } catch (error) {
            console.error(error);
            handleError();
        }
        
        return false;
    };


    $('button[type=submit]').on('click', handleSubmit); 
});
</script>
</body>
EOT;

        $content = $event->output;

        $event->output = str_replace("</body>", $jsCode, $content);
    }


    /**
     * @param $event
     * @param $model Stripe
     * @return void
     */
    public static function displayACHCodeOnView($event, Stripe $model, $connected_account_id = null)
    {

        $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);
//        $connected_account_id = Yii::$app->user->identity->stripe_account_id;

        //$formModel = Form::findOne(['id' => $model->form_id]);
        if (empty($connected_account_id)) {

            $user = \app\models\User::findIdentity($model->form->created_by);
            $connected_account_id = $user->stripe_account_id;
        }

        // Required
        $required = $model->required ? 'true' : 'false';
        $requiredCssClass = $model->required ? 'required-control' : '';

        // Label
        $label = empty($model->label) ? Yii::t('app', 'Credit or debit card') : $model->label;
        $label = Html::label($label, 'stripe', ['class' => 'control-label stripe-card-label']);

        $cardholder_name = $model->cardholder_name;
        $receipt_email = $model->receipt_email;
        $description = $model->description;
        $statement_descriptor = $model->statement_descriptor;

        $cardholderNotEmpty = !empty($cardholder_name) ? 'true' : 'false';
        $emailNotEmpty = !empty($receipt_email) ? 'true' : 'false';

        $jsCode = <<<EOT

<script>

$(document).ready(function(){
    var stripe = Stripe('{$publishableKey}');
    const options = {
      mode: 'payment',
      currency: 'usd',
      amount: 100,
      payment_method_types: [
           'us_bank_account',
       ],
      payment_method_options: {
        us_bank_account: {
            verification_method: 'instant'
        },
      },
    };
    var elements = stripe.elements(options);
    
    const paymentElement = elements.create("payment", {
              defaultValues: {
                billingDetails: {
                  name: $('input[name={$cardholder_name}]').val(),
                  email: $('input[name={$receipt_email}]').val()
                }
              }
            });
    paymentElement.mount("#ach-payment-element");
    
    if ({$cardholderNotEmpty})
        $('input[name={$cardholder_name}]').on('change',function(e){
            var paymentElement = elements.getElement('payment');
            
            // Update with modified defaultValues
            paymentElement.update({
              defaultValues: {
                billingDetails: {
                  name: $(this).val()
                }
              }
            });
        });
    
    if ({$emailNotEmpty}) {
        $('input[name={$receipt_email}]').on('change',function(e){
            var paymentElement = elements.getElement('payment');
            
            // Update with modified defaultValues
            paymentElement.update({
              defaultValues: {
                billingDetails: {
                  email: $(this).val()
                }
              }
            });
        });
    }

    const handleSubmit = async (event) => {
        event.preventDefault();
        
        if (!stripe) {
            return;
        }
        
        clearError();
        
        console.log($("#full-ach").css("max-height"));
        if ($("#full-ach").css("max-height") == '0px')
            return;
        
        // Trigger form validation and wallet collection
        const {error: submitError} = await elements.submit();
        if (submitError) {
            console.log("Payment Not Filled Out");
            
            if ({$required}) {
                handleError(submitError);
                return;
            }
            else {
                console.log("Payment Not Filled & Not Required");
                formEl.submit();
                return;
            }
        }
        
        $("input[name=payment_type]").val("full");
        
        const amount = $('#amountTotal').val();
        const subTotalAmount = $('#amountSubTotal').val();
        const fullname = $('input[name="{$cardholder_name}"]').val(); 
        const email = $('input[name="{$receipt_email}"]').val();
        
        const result = await fetch("/create-intent.php", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({
            amountTotal: amount,
            subTotal: subTotalAmount,
            amountTransfer: subTotalAmount,
            email: email,
            fullname: fullname,
            description: '{$description}',
            statement_descriptor: '{$statement_descriptor}',
            connected_account_id: "{$connected_account_id}",
            currency: "usd",
            paymentMethod: "ach",
          }),
        }).then((r) => r.json());
        
        const clientSecret = result.clientSecret;
        
        try {
              const { error, paymentIntent } = await stripe.confirmPayment({
                elements,
                clientSecret,
                // confirmParams: {
                //   return_url: "https://google.com",
                // },
                redirect: "if_required",
              });
              
              if (error) {
                console.error(error);
                handleError();
              } else if (paymentIntent && paymentIntent.status === "succeeded") {
                console.log("Payment succeeded");
                handleSuccess();
                
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
              } else if (paymentIntent && paymentIntent.status === "processing") {
                console.log("Payment Prcoessing");
                handleProcessing();
                  
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                  
                // Submit form
                formEl.submit();
              } else if (paymentIntent && paymentIntent.status === "requires_action") {
                console.log("Payment Requires Action");
                handleRequiresAction();
                  
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'paymentIntent');
                hiddenInput.setAttribute('value', paymentIntent.id);
                formEl.find('[name="paymentIntent"]').remove();
                formEl.append(hiddenInput);
                  
                // Submit form
                formEl.submit();
              } else {
                console.log(paymentIntent);
                console.log("Payment failed");
                handleError();
              }
        } catch (error) {
            console.error(error);
            handleError();
        }
        
        return false;
    };


    $('button[type=submit]').on('click', handleSubmit); 

});
</script>
</body>
EOT;

        $content = $event->output;


        $event->output = str_replace("</body>", $jsCode, $content);

    }

    public static function displaySubscribeCreditCard($event, Stripe $model, $connected_account_id = null)
    {

        $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);
//        $connected_account_id = Yii::$app->user->identity->stripe_account_id;

        //$formModel = Form::findOne(['id' => $model->form_id]);
        if (empty($connected_account_id)) {

            $user = \app\models\User::findIdentity($model->form->created_by);
            $connected_account_id = $user->stripe_account_id;
        }

        // Required
        $required = $model->required ? 'true' : 'false';
        $requiredCssClass = $model->required ? 'required-control' : '';

        $cardholder_name = $model->cardholder_name;
        $receipt_email = $model->receipt_email;
        $description = $model->description;
        $statement_descriptor = $model->statement_descriptor;
        $interval = $model->installment_interval;
        $num_installments = $model->num_installments;

        $cardholderNotEmpty = !empty($cardholder_name) ? 'true' : 'false';
        $emailNotEmpty = !empty($receipt_email) ? 'true' : 'false';

        $jsCode = <<<EOT

<script>

$(document).ready(function(){
    var stripe = Stripe('{$publishableKey}');
    const options = {
      mode: 'setup',
      currency: 'usd',
      payment_method_types: [
           'card',
       ],
    };
    var elements = stripe.elements(options);
    
    const paymentElement = elements.create("payment", {
              defaultValues: {
                billingDetails: {
                  name: $('input[name={$cardholder_name}]').val(),
                  email: $('input[name={$receipt_email}]').val()
                }
              }
            });
    paymentElement.mount("#subscription-payment-element");
    
    if ({$cardholderNotEmpty})
        $('input[name={$cardholder_name}]').on('change',function(e){
            var paymentElement = elements.getElement('payment');
            
            // Update with modified defaultValues
            paymentElement.update({
              defaultValues: {
                billingDetails: {
                  name: $(this).val()
                }
              }
            });
        });
    
    if({$emailNotEmpty})
        $('input[name={$receipt_email}]').on('change',function(e){
            var paymentElement = elements.getElement('payment');
            
            // Update with modified defaultValues
            paymentElement.update({
              defaultValues: {
                billingDetails: {
                  email: $(this).val()
                }
              }
            });
        });

    const handleSubmit = async (event) => {
        event.preventDefault();
        
        if (!stripe) {
            return;
        }
        
        clearError();
        
        console.log($("#subscribe-card").css("max-height"));
        if ($("#subscribe-card").css("max-height") == '0px')
            return;
        
        // Trigger form validation and wallet collection
        const {error: submitError} = await elements.submit();
        if (submitError) {
            console.log("Payment Not Filled Out");
            
            if ({$required}) {
                handleError(submitError);
                return;
            }
            else {
                console.log("Payment Not Filled & Not Required");
                formEl.submit();
                return;
            }
        }
        
        $("input[name=payment_type]").val("installments");
        
        const amountSubTotal = $('#amountSubTotal').val(); // without fees 
        const amount = $('#amountTotal').val();
        const recurringSubTotal = $('#recurringSubTotal').val();
        const recurringTotal = $('#recurringTotal').val();
        const fullname = $('input[name="{$cardholder_name}"]').val(); 
        const email = $('input[name="{$receipt_email}"]').val();
        
        const result = await fetch("/create-setupintent.php", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({
            amountSubTotal: amountSubTotal,
            amountTotal: amount,
            recurringSubTotal: recurringSubTotal,
            recurringTotal: recurringTotal,
            email: email,
            fullname: fullname,
            description: '{$description}',
            statement_descriptor: '{$statement_descriptor}',
            interval: '{$interval}',
            num_installments: '{$num_installments}',
            connected_account_id: "{$connected_account_id}",
            paymentMethod: "card",
          }),
        }).then((r) => r.json());
        
        const clientSecret = result.clientSecret;
        
        try {
              const result = await stripe.confirmSetup({
                elements,
                clientSecret,
                redirect: "if_required",
              })
              .then(function(result) {
                  console.log(result);
                  if (result.error != null) {
                    // Inform the customer that there was an error.
                    console.log("rejected");
                    return result;
                  }
                  else {
                      console.log("succeeded");
                      return result;
                  }
                });
              
              if (result.error != null) {
                console.error(result.error);
                handleError();
              } else if (result.setupIntent && result.setupIntent.status === "succeeded") {
                console.log("Setup succeeded");
                handleSuccess();
                
//                const subscriptionResult = await fetch("/create-subscription.php", {
//                  method: "POST",
//                  headers: { "Content-Type": "application/json" },
//                  body: JSON.stringify({
//                    amountSubTotal: amountSubTotal,
//                    amountTotal: amount,
//                    recurringSubTotal: recurringSubTotal,
//                    recurringTotal: recurringTotal,
//                    email: email,
//                    fullname: fullname,
//                    description: '{$description}',
//                    statement_descriptor: '{$statement_descriptor}',
//                    interval: '{$interval}',
//                    num_installments: '{$num_installments}',
//                    setup_intent: result.setupIntent.id,
//                    connected_account_id: "{$connected_account_id}"
//                  }),
//                }).then((r) => r.json());
                
                
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'setupIntent');
                hiddenInput.setAttribute('value', result.setupIntent.id);
                formEl.find('[name="setupIntent"]').remove();
                formEl.append(hiddenInput);
                
                // hiddenInput = document.createElement('input');
                // hiddenInput.setAttribute('type', 'hidden');
                // hiddenInput.setAttribute('name', 'subscriptionId');
                // hiddenInput.setAttribute('value', subscriptionResult.subscriptionId);
                // formEl.find('[name="subscriptionId"]').remove();
                // formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
              } else if (result.setupIntent && result.setupIntent.status === "processing") {
                  console.log("Setup processing");

                  handleProcessing();
                  
//                  const subscriptionResult = await fetch("/create-subscription.php", {
//                  method: "POST",
//                  headers: { "Content-Type": "application/json" },
//                  body: JSON.stringify({
//                    amountSubTotal: amountSubTotal,
//                    amountTotal: amount,
//                    recurringSubTotal: recurringSubTotal,
//                    recurringTotal: recurringTotal,
//                    email: email,
//                    fullname: fullname,
//                    description: '{$description}',
//                    statement_descriptor: '{$statement_descriptor}',
//                    interval: '{$interval}',
//                    num_installments: '{$num_installments}',
//                    setup_intent: result.setupIntent.id,
//                    connected_account_id: "{$connected_account_id}"
//                  }),
//                }).then((r) => r.json());
                
                
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'setupIntent');
                hiddenInput.setAttribute('value', result.setupIntent.id);
                formEl.find('[name="setupIntent"]').remove();
                formEl.append(hiddenInput);
                
                // hiddenInput = document.createElement('input');
                // hiddenInput.setAttribute('type', 'hidden');
                // hiddenInput.setAttribute('name', 'subscriptionId');
                // hiddenInput.setAttribute('value', subscriptionResult.subscriptionId);
                // formEl.find('[name="subscriptionId"]').remove();
                // formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
                  
              } else if (result.setupIntent && result.setupIntent.status === "requires_action") {
                console.log("Setup requires action");

                handleRequiresAction();
                  
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'setupIntent');
                hiddenInput.setAttribute('value', result.setupIntent.id);
                formEl.find('[name="setupIntent"]').remove();
                formEl.append(hiddenInput);
                
                // hiddenInput = document.createElement('input');
                // hiddenInput.setAttribute('type', 'hidden');
                // hiddenInput.setAttribute('name', 'subscriptionId');
                // hiddenInput.setAttribute('value', subscriptionResult.subscriptionId);
                // formEl.find('[name="subscriptionId"]').remove();
                // formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
                  
              } else {
                console.log(result);
                console.log("Setup failed");
                handleError();
              }
        } catch (error) {
            console.error(error);
            handleError();
        }
        
        return false;
    };


    $('button[type=submit]').on('click', handleSubmit); 

});
</script>
</body>
EOT;

        $content = $event->output;

        $event->output = str_replace("</body>", $jsCode, $content);

    }

    public static function displaySubscribeACH($event, Stripe $model, $connected_account_id = null)
    {
        $publishableKey = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['stripeLivePublishableKey'] : Yii::$app->params['stripeTestPublishableKey']);
//        $connected_account_id = Yii::$app->user->identity->stripe_account_id;

        //$formModel = Form::findOne(['id' => $model->form_id]);
        if (empty($connected_account_id)) {

            $user = \app\models\User::findIdentity($model->form->created_by);
            $connected_account_id = $user->stripe_account_id;
        }

        // Required
        $required = $model->required ? 'true' : 'false';
        $requiredCssClass = $model->required ? 'required-control' : '';

        $cardholder_name = $model->cardholder_name;
        $receipt_email = $model->receipt_email;
        $description = $model->description;
        $statement_descriptor = $model->statement_descriptor;
        $interval = $model->installment_interval;
        $num_installments = $model->num_installments;

        $cardholderNotEmpty = !empty($cardholder_name) ? 'true' : 'false';
        $emailNotEmpty = !empty($receipt_email) ? 'true' : 'false';

        $jsCode = <<<EOT

<script>

$(document).ready(function(){
    var stripe = Stripe('{$publishableKey}');
    const options = {
      mode: 'setup',
      currency: 'usd',
      payment_method_types: [
           'us_bank_account',
       ],
      payment_method_options: {
        us_bank_account: {
            verification_method: 'instant'
        },
      },
    };
    var elements = stripe.elements(options);
    
    const paymentElement = elements.create("payment", {
              defaultValues: {
                billingDetails: {
                  name: $('input[name={$cardholder_name}]').val(),
                  email: $('input[name={$receipt_email}]').val()
                }
              }
            });
    paymentElement.mount("#subscription-ach-payment-element");
    
    if ({$cardholderNotEmpty})
        $('input[name={$cardholder_name}]').on('change',function(e){
            var paymentElement = elements.getElement('payment');
            
            // Update with modified defaultValues
            paymentElement.update({
              defaultValues: {
                billingDetails: {
                  name: $(this).val()
                }
              }
            });
        });
    
    if ({$emailNotEmpty})
        $('input[name={$receipt_email}]').on('change',function(e){
            var paymentElement = elements.getElement('payment');
            
            // Update with modified defaultValues
            paymentElement.update({
              defaultValues: {
                billingDetails: {
                  email: $(this).val()
                }
              }
            });
        });

    const handleSubmit = async (event) => {
        event.preventDefault();
        
        if (!stripe) {
            return;
        }
        
        clearError();
        
        console.log($("#subscribe-ach").css("max-height"));
        if ($("#subscribe-ach").css("max-height") == '0px')
            return;
        
        // Trigger form validation and wallet collection
        const {error: submitError} = await elements.submit();
        if (submitError) {
            console.log("Payment Not Filled Out");
            
            if ({$required}) {
                handleError(submitError);
                return;
            }
            else {
                console.log("Payment Not Filled & Not Required");
                formEl.submit();
                return;
            }
        }
        
        $("input[name=payment_type]").val("installments");
        
        const amountSubTotal = $('#amountSubTotal').val(); // without fees 
        const amount = $('#amountTotal').val();
        const recurringSubTotal = $('#recurringSubTotal').val();
        const recurringTotal = $('#recurringTotal').val();
        const fullname = $('input[name="{$cardholder_name}"]').val(); 
        const email = $('input[name="{$receipt_email}"]').val();
        
        const result = await fetch("/create-setupintent.php", {
          method: "POST",
          headers: { "Content-Type": "application/json" },
          body: JSON.stringify({
            amountSubTotal: amountSubTotal,
            amountTotal: amount,
            recurringSubTotal: recurringSubTotal,
            recurringTotal: recurringTotal,
            email: email,
            fullname: fullname,
            description: '{$description}',
            statement_descriptor: '{$statement_descriptor}',
            interval: '{$interval}',
            num_installments: '{$num_installments}',
            connected_account_id: "{$connected_account_id}",
            paymentMethod: "ach",
          }),
        }).then((r) => r.json());
        
        const clientSecret = result.clientSecret;
        
        try {
              const result = await stripe.confirmSetup({
                elements,
                clientSecret,
                // confirmParams: {
                //   return_url: "https://google.com",
                // },
                redirect: "if_required",
              })
              .then(function(result) {
                  console.log(result);
                  if (result.error != null) {
                    // Inform the customer that there was an error.
                    console.log("rejected");
                    return result;
                  }
                  else {
                      console.log("succeeded");
                      return result;
                  }
                });
              
              if (result.error != null) {
                console.error(result.error);
                handleError();
              } else if (result.setupIntent && result.setupIntent.status === "succeeded") {
                console.log("Setup succeeded");
                handleSuccess();
                
//                const subscriptionResult = await fetch("/create-subscription.php", {
//                  method: "POST",
//                  headers: { "Content-Type": "application/json" },
//                  body: JSON.stringify({
//                    amountSubTotal: amountSubTotal,
//                    amountTotal: amount,
//                    recurringSubTotal: recurringSubTotal,
//                    recurringTotal: recurringTotal,
//                    email: email,
//                    fullname: fullname,
//                    description: '{$description}',
//                    statement_descriptor: '{$statement_descriptor}',
//                    interval: '{$interval}',
//                    num_installments: '{$num_installments}',
//                    setup_intent: result.setupIntent.id,
//                    connected_account_id: "{$connected_account_id}"
//                  }),
//                }).then((r) => r.json());
                
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'setupIntent');
                hiddenInput.setAttribute('value', result.setupIntent.id);
                formEl.find('[name="setupIntent"]').remove();
                formEl.append(hiddenInput);
                
                
                // hiddenInput = document.createElement('input');
                // hiddenInput.setAttribute('type', 'hidden');
                // hiddenInput.setAttribute('name', 'subscriptionId');
                // hiddenInput.setAttribute('value', subscriptionResult.subscriptionId);
                // formEl.find('[name="subscriptionId"]').remove();
                // formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
              } else if (result.setupIntent && result.setupIntent.status === "processing") {
                  handleProcessing();
                  
//                  const subscriptionResult = await fetch("/create-subscription.php", {
//                  method: "POST",
//                  headers: { "Content-Type": "application/json" },
//                  body: JSON.stringify({
//                    amountSubTotal: amountSubTotal,
//                    amountTotal: amount,
//                    recurringSubTotal: recurringSubTotal,
//                    recurringTotal: recurringTotal,
//                    email: email,
//                    fullname: fullname,
//                    description: '{$description}',
//                    statement_descriptor: '{$statement_descriptor}',
//                    interval: '{$interval}',
//                    num_installments: '{$num_installments}',
//                    setup_intent: result.setupIntent.id,
//                    connected_account_id: "{$connected_account_id}"
//                  }),
//                }).then((r) => r.json());
                
                
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'setupIntent');
                hiddenInput.setAttribute('value', result.setupIntent.id);
                formEl.find('[name="setupIntent"]').remove();
                formEl.append(hiddenInput);
                
                // hiddenInput = document.createElement('input');
                // hiddenInput.setAttribute('type', 'hidden');
                // hiddenInput.setAttribute('name', 'subscriptionId');
                // hiddenInput.setAttribute('value', subscriptionResult.subscriptionId);
                // formEl.find('[name="subscriptionId"]').remove();
                // formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
                  
              } else if (result.setupIntent && result.setupIntent.status === "requires_action") {
                handleRequiresAction();
                  
                var hiddenInput = document.createElement('input');
                hiddenInput.setAttribute('type', 'hidden');
                hiddenInput.setAttribute('name', 'setupIntent');
                hiddenInput.setAttribute('value', result.setupIntent.id);
                formEl.find('[name="setupIntent"]').remove();
                formEl.append(hiddenInput);
                
                // hiddenInput = document.createElement('input');
                // hiddenInput.setAttribute('type', 'hidden');
                // hiddenInput.setAttribute('name', 'subscriptionId');
                // hiddenInput.setAttribute('value', subscriptionResult.subscriptionId);
                // formEl.find('[name="subscriptionId"]').remove();
                // formEl.append(hiddenInput);
                
                // Submit form
                formEl.submit();
                 
              } else {
                console.log(result);
                console.log("Payment failed");
                // handleOther();
                handleError();
              }
        } catch (error) {
            console.error(error);
            handleError();
        }
        
        return false;
    };


    $('button[type=submit]').on('click', handleSubmit); 

});
</script>
</body>
EOT;

        $content = $event->output;

        $event->output = str_replace("</body>", $jsCode, $content);

    }

    /**
     * Return parameters for Stripe Checkout
     *
     * @param $model
     * @param $formModel
     * @param $submissionModel
     * @param $submissionData
     * @param $stripeService
     * @return array
     */
    public static function generateCheckoutParameters($model, $formModel, $submissionModel, $submissionData, $stripeService)
    {
        $i = 0;
        $items = [];
        $metadata = [
            'app' => Yii::$app->name,
            'form_id' => $formModel->id,
            'submission_id' => $submissionModel->id,
        ];

        // Add User ID to Metadata
        if (!Yii::$app->user->isGuest) {
            $metadata['user_id'] = Yii::$app->user->id;
        }

        $currency = !empty($model->currency) ? $model->currency : 'usd';
        if (!empty($model->currency) && !empty($submissionData[$model->currency])) {
            $currency = is_array($submissionData[$model->currency]) ? implode('', $submissionData[$model->currency]) : $submissionData[$model->currency];
        }
        $successUrl = Url::to(['/addons/stripe/check/payment', 'id' => $model->id, 'form_id' => $formModel->id, 'submission_id' => $submissionModel->id], true);
        $successUrl = $successUrl . "&session_id={CHECKOUT_SESSION_ID}";

        $params = [
            'mode' => 'payment',
            'success_url' => $successUrl,
            'cancel_url' => $model->cancel_url,
        ];

        // Payment method types
        if (!empty($model->payment_method_types)) {
            $params['payment_method_types'] = $model->payment_method_types;
        }

        // Customer ID
        if (!empty($model->receipt_email) && !empty($submissionData[$model->receipt_email])) {
            $email = is_array($submissionData[$model->receipt_email]) && !empty($submissionData[$model->receipt_email][0]) ? $submissionData[$model->receipt_email][0] : $submissionData[$model->receipt_email];
            $customerID = $stripeService->findCustomerIdBy([
                'email' => $email,
            ]);
            if (empty($customerID)) {
                $params['customer_email'] = $email;
            } else {
                $params['customer'] = $customerID;
            }
        }

        // Billing Address
        if ($model->billing_address) {
            $params['billing_address_collection'] = 'required';
        }

        // Subscription
        if ($model->checkout && $model->subscription) {

            // Trial period
            if ($model->trial && $model->trial_days > 0) {
                $params['subscription_data']['trial_period_days'] = $model->trial_days;
            }

            foreach ($model->items as $itemModel) {
                // Check field value
                $quantity = isset($itemModel->quantity, $submissionData[$itemModel->quantity]) &&
                !empty($submissionData[$itemModel->quantity]) ?
                    $submissionData[$itemModel->quantity] : 1;
                $quantity = is_array($quantity) ? array_sum($quantity) : $quantity;
                $price = isset($itemModel->price, $submissionData[$itemModel->price]) &&
                !empty($submissionData[$itemModel->price]) ?
                    $submissionData[$itemModel->price] : '';
                // Array of pricing plans
                $price = is_array($price) ? $price : explode(',', $price);
                foreach ($price as $price_id) {
                    if (!empty($price_id)) {
                        array_push($items, [
                            'price' => $price_id,
                            'quantity' => $quantity,
                        ]);
                        $metadata['item_' . ++$i] = 'Description: ' . $itemModel->description . ' - Price ID: ' . $price_id . ' - Quantity: ' . $quantity;
                    }
                }
            }

            $params['mode'] = 'subscription';
            $params['line_items'] = $items;
            $params['subscription_data'] = [
                'metadata' => $metadata,
            ];

        } else { // One-Time Payment

            // Line Items
            foreach ($model->items as $itemModel) {
                // Check field value
                $quantity = isset($itemModel->quantity, $submissionData[$itemModel->quantity]) &&
                !empty($submissionData[$itemModel->quantity]) ?
                    $submissionData[$itemModel->quantity] : 1;
                $price = isset($itemModel->price, $submissionData[$itemModel->price]) &&
                !empty($submissionData[$itemModel->price]) ?
                    $submissionData[$itemModel->price] : 0;

                // Sum values if field value is an array
                $quantity = is_array($quantity) ? array_sum($quantity) : $quantity;
                $price = is_array($price) ? array_sum($price) : $price;

                array_push($items, [
                    'price_data' => [
                        'currency' => $currency,
                        'product_data' => [
                            'name' => $itemModel->description,
                        ],
                        'unit_amount' => $price * 100, // Stripe Accepts Charges In Cents
                    ],
                    'quantity' => $quantity,
                ]);

                $metadata['item_' . ++$i] = 'Description: ' . $itemModel->description . ' - Price: ' . number_format($price, 2) . ' - Quantity: ' . $quantity . ' - SubTotal: ' . number_format( $quantity * $price, 2);
            }

            $params['line_items'] = $items;
            $params['payment_intent_data'] = [
                'metadata' => $metadata,
            ];
        }

        return $params;
    }
}