<?php

use app\modules\addons\modules\smtp\models\Smtp;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\smtp\models\Smtp */
/* @var $form \yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */

?>

<div class="smtp-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'name')->textInput([
                'maxlength' => true,
            ])->hint(Yii::t('app', 'Provides a human-readable identifier for this particular SMTP configuration.')) ?>
        </div>
        <div class="col-sm-3">
            <?php $model->status = $model->isNewRecord ? 1 : $model->status; ?>
            <?= $form->field($model, 'status')->widget(SwitchInput::class, [
                'pluginOptions' => [
                    'onColor' => 'primary',
                ],
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'selected_forms')
                ->widget(Select2::class, [
                    'data' => $forms,
                    'options' => [
                        'hideSearch' => true,
                        'multiple' => true,
                    ],
                    'pluginOptions' => [
                        'placeholder' => Yii::t('app', 'Select a Form...'),
                        'allowClear' => true,
                    ],
                ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-8">
            <?= $form->field($model, 'host')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'port')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-2">
            <?= $form->field($model, 'encryption')->dropDownList([
                Smtp::ENCRYPTION_TLS => Smtp::ENCRYPTION_TLS,
                Smtp::ENCRYPTION_SSL => Smtp::ENCRYPTION_SSL,
                Smtp::ENCRYPTION_NONE => Smtp::ENCRYPTION_NONE,
            ]); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'username')->textInput([
                'maxlength' => true,
                'spellcheck' => 'false',
                'autocomplete' => 'off' ,
                'autocorrect' => 'off',
                'autocapitalize' => 'off',
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'password')->passwordInput([
                'maxlength' => true,
                'autocomplete' => 'new-password',
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'email_address')->textInput([
                'maxlength' => true,
                'type' => 'email',
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'from_name')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="form-group" style="margin-top: 20px">
                <?= Html::submitButton($model->isNewRecord ?
                    Yii::t('app', 'Save') :
                    Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
            </div>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>