<?php
namespace app\modules\addons\modules\smtp\models;

use app\components\behaviors\DateTrait;
use app\models\Form;
use app\models\Theme;
use app\models\User;
use Yii;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_smtp_form}}".
 *
 * @property integer $id
 * @property integer $smtp_id
 * @property integer $form_id
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Smtp $smtp
 * @property Form $form
 * @property User $author
 * @property User $lastEditor
 */
class SmtpForm extends \yii\db\ActiveRecord
{
    use DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_smtp_form}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['smtp_id', 'form_id', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'smtp_id' => Yii::t('app', 'Smtp ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSmtp()
    {
        return $this->hasOne(Smtp::class, ['id' => 'smtp_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }
}