<?php

use yii\db\Migration;

/**
 * Class m211109_054704_smtp_1_0
 */
class m211109_054704_smtp_1_0 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_smtp}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'status' => $this->boolean()->notNull()->defaultValue(0),

            // Settings
            'name' => $this->string(191),
            'event' => $this->string(191),
            'conditions' => $this->text(),

            // SMTP Settings
            'host' => $this->string(191),
            'port' => $this->string(191),
            'encryption' => $this->string(191),
            'auth' => $this->string(191),
            'username' => $this->string(191),
            'password' => $this->string(191),
            'email_address' => $this->string(191),
            'async' => $this->boolean(),

            'created_by' => $this->integer(),
            'updated_by' => $this->integer(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_smtp_form}}', [
            'id' => $this->primaryKey(),

            // Settings
            'smtp_id' => $this->integer()->notNull(),
            'form_id' => $this->integer()->notNull(),

            'created_by' => $this->integer(),
            'updated_by' => $this->integer(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_smtp}}');
        $this->dropTable('{{%addon_smtp_form}}');
    }

}
