<?php

use app\components\widgets\ConditionsBuilder;
use yii\helpers\Html;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\sendinblue\models\SendinBlue */
/* @var $fieldModel app\modules\addons\modules\sendinblue\models\SendinBlueField */
/* @var $form yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */
/* @var $lists array [id => name] of Subscriber Lists */
/* @var $fields array [id => name] of Custom Fields */
/* @var $connected boolean The connection to SendinBlue has been established */

$formFieldUrl = Url::to(['/addons/sendinblue/admin/fields']);
?>

<div class="sendinblue-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'api_key')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <span class="help-block">
                <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                <?= Yii::t(
                    'app',
                    'For connecting to your SendinBlue account you need API access.'
                ) ?>
                <?= Html::a(Yii::t('app', 'Go to SendinBlue'), 'https://www.sendinblue.com', ['target' => '_blank']) ?>.
            </span>
        </div>
    </div>

    <?php if ($connected && !empty($model->api_key)): ?>

        <div class="row" style="margin-top: 20px;">
            <div class="col-sm-12">
                <?= $form->field($model, 'name')->textInput([
                    'placeholder' => Yii::t('app', "Enter a configuration name..."),
                    'maxlength' => true,
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'form_id')->widget(Select2::class, [
                    'data' => $forms,
                    'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ])->label(Yii::t('app', 'Form')); ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'contact_list')->widget(Select2::class, [
                    'data' => $lists,
                    'options' => [
                        'placeholder' => Yii::t('app', 'Select a list...'),
                        'multiple' => true,
                    ],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ])->hint( Yii::t(
                    'app',
                    'Select the list in which you want to add subscribers.'
                ))->label(Yii::t('app', 'List')); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <?php if ($model->isNewRecord) { $model->status = 1;} ?>
                <?= $form->field($model, 'status')->widget(SwitchInput::class)->hint(Yii::t(
                    'app',
                    'Disables the integration at any time.'
                )) ?>
            </div>
            <div class="col-sm-3">
                <?php if ($model->isNewRecord) { $model->subscriber_update_enabled = 1;} ?>
                <?= $form->field($model, 'subscriber_update_enabled')->widget(SwitchInput::class)->hint(Yii::t(
                    'app',
                    'Update an existing contact'
                )) ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'event')->widget(Select2::class, [
                    'data' => \app\helpers\EventHelper::supportedFormEvents(),
                ]); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <?= ConditionsBuilder::widget([
                    'label' => Yii::t('app', 'Conditions'),
                ]) ?>
                <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
            </div>
        </div>

        <div class="row" style="margin-top: 20px">
            <div class="col-sm-3">
                <?= Html::hiddenInput('subscriber-email', $model->subscriber_email, ['id'=>'subscriber-email']) ?>
                <?= $form->field($model, 'subscriber_email')->widget(DepDrop::class, [
                    'pluginOptions' => [
                        'depends' => ['sendinblue-form_id'],
                        'placeholder' => Yii::t('app', 'Select...'),
                        'url' => $formFieldUrl,
                        'params' => ['subscriber-email']
                    ]
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($model, 'subscriber_email_blacklisted')->widget(SwitchInput::class) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($model, 'subscriber_sms_blacklisted')->widget(SwitchInput::class) ?>
            </div>
            <div class="col-sm-3">
                <?= $form->field($model, 'subscriber_smtp_blacklist_sender')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
            </div>
        </div>

        <?php if ($model->isNewRecord || count($model->items) === 0): ?>

            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($fieldModel, '[0]form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['sendinblue-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($fieldModel, '[0]list_field')->dropDownList($fields, [
                                'prompt'=> Yii::t('app', 'Select...')
                        ]); ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-add">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </fieldset>

            <fieldset id="itemTemplate" class="d-none">
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($fieldModel, 'form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['sendinblue-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($fieldModel, 'list_field')->dropDownList($fields, [
                            'prompt'=> Yii::t('app', 'Select...'),
                            'disabled' => true,
                        ]); ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-remove">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </fieldset>

        <?php else: ?>

            <?php foreach($model->items as $i => $item): ?>
                <fieldset class="item">
                    <div class="row">
                        <div class="col-sm-6">
                            <?= Html::hiddenInput('item-'.$i.'-form_field',
                                $item->form_field, ['id'=>'item-'.$i.'-form_field']) ?>
                            <?= $form->field($fieldModel, '['.$i.']form_field')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['sendinblue-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $formFieldUrl,
                                    'params'=>['item-'.$i.'-form_field'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-5">
                            <?= $form->field($item, '['.$i.']list_field')->dropDownList($fields, [
                                'prompt'=> Yii::t('app', 'Select...')
                            ]); ?>
                        </div>
                        <div class="col-sm-1">
                            <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </fieldset>
            <?php endforeach; ?>

            <fieldset id="itemTemplate" class="d-none">
                <div class="row">
                    <div class="col-sm-6">
                        <?= Html::hiddenInput('item-form_field', '', ['id'=>'item-form_field']) ?>
                        <?= $form->field($fieldModel, 'form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['sendinblue-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                                'params'=>['item-form_field'],
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($fieldModel, 'list_field')->dropDownList($fields, [
                            'prompt'=> Yii::t('app', 'Select...'),
                            'disabled' => true,
                        ]); ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </fieldset>

        <?php endif; ?>

    <?php endif; ?>

    <div class="form-group" style="margin-top: 20px">
        <?= Html::submitButton( !$connected ?
            ' <i class="fas fa-external-link-square me-2"></i> ' . Yii::t('app', 'Connect to SendinBlue'):
            ' <i class="fas fa-check me-2"></i> ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#sendinblue-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['sendinblue-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'sendinblue-conditions');

/**
 * Field Mapping
 */

if ($model->isNewRecord || count($model->items) === 0) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update name attribute
            cloned
                .find('[name="SendinBlueField[form_field]"]')
                    .attr('name', 'SendinBlueField[' + item + '][form_field]')
                    .attr('id', 'sendinbluefield-' + item + '-form_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['sendinblue-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="SendinBlueField[list_field]"]')
                    .attr('name', 'SendinBlueField[' + item + '][list_field]')
                    .attr('id', 'sendinbluefield-' + item + '-list_field')
                    .removeAttr('disabled')
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(window).on('load', function() {
    $('#sendinblue-form_id').trigger('depdrop.change');
    $('#sendinblue-contact_list').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update name attribute
            cloned
                .find('[name="SendinBlueField[form_field]"]')
                    .attr('name', 'SendinBlueField[' + item + '][form_field]')
                    .attr('id', 'sendinbluefield-' + item + '-form_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['sendinblue-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="SendinBlueField[list_field]"]')
                    .attr('name', 'SendinBlueField[' + item + '][list_field]')
                    .attr('id', 'sendinbluefield-' + item + '-list_field')
                    .removeAttr('disabled')
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
}

$this->registerJs($script, $this::POS_END);

?>