<?php

namespace app\modules\addons\modules\sendinblue\models;

use Yii;

/**
 * This is the model class for table "{{%addon_sendinblue_item}}".
 *
 * @property integer $id
 * @property integer $sendinblue_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class SendinBlueField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_sendinblue_field}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['sendinblue_id', 'form_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'sendinblue_id' => Yii::t('app', 'SendinBlue ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSendinBlue()
    {
        return $this->hasOne(SendinBlue::class,['sendinblue_id'=>'id']);
    }
}
