<?php

use yii\db\Migration;

/**
 * Class m200628_144107_update_to_1_2
 */
class m200628_144107_update_to_1_2 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_sendinblue}}', 'name', $this->text()->notNull()->after('status'));
        $this->addColumn('{{%addon_sendinblue}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_sendinblue}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_sendinblue_field}}', 'sendinblue_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_sendinblue_field}}', 'sendinblue_id');

        $this->dropColumn('{{%addon_sendinblue}}', 'event');
        $this->dropColumn('{{%addon_sendinblue}}', 'conditions');
        $this->dropColumn('{{%addon_sendinblue}}', 'name');
    }

}
