<?php

use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\salesforce\models\Salesforce */
/* @var $fieldModel app\modules\addons\modules\salesforce\models\SalesforceField */
/* @var $forms array [id => name] of Form models */

$this->title = Yii::t('app', 'Send Form Submissions');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Salesforce'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Form') .' #'.
    $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="salesforce-send-page box box-big box-light">

    <div class="box-header">
        <h3 class="box-title"><?= $this->title ?>
            <span class="box-subtitle"><?= Html::encode($model->form->name) ?></span>
        </h3>
    </div>

    <div class="salesforce-form">
        <?php $form = ActiveForm::begin(); ?>

        <h4><?= Yii::t('app', 'Are you sure do you want to send all form submissions to Salesforce?') ?></h4>
        <p class="text-muted"><?= Yii::t('app', 'We will take into account your form configuration to process this request.') ?></p>

        <div class="form-group">
            <?= Html::checkbox('resent', false, [
                'label' => 'Include sent entries',
                'labelOptions' => [
                    'class' => 'control-label',
                ],
            ]) ?>
        </div>

        <div class="form-group" style="margin-top: 20px">
            <?= Html::submitButton(
                    ' <i class="glyphicon glyphicon-send"></i> '
                    . Yii::t('app', 'Send'),
                    ['class' => 'btn btn-primary']) ?>
        </div>

        <?php ActiveForm::end(); ?>
    </div>
</div>
