<?php

use yii\web\View;
use yii\helpers\Url;
use yii\helpers\Html;
use kartik\grid\GridView;
use kartik\switchinput\SwitchInput;
use Carbon\Carbon;
use app\components\widgets\ActionBar;
use app\components\widgets\PageSizeDropDownList;
use kartik\datecontrol\Module as DateControlModule;

/* @var $this yii\web\View */
/* @var $searchModel app\modules\addons\modules\salesforce\models\SalesforceLogSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $model app\modules\addons\modules\salesforce\models\Salesforce */

$this->title = Yii::t('app', 'Salesforce Log');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Salesforce'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Form') .' #'.
    $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = Yii::t('app', 'Log');

/** @var kartik\datecontrol\Module $dateControlModule */
$dateControlModule = \Yii::$app->getModule('datecontrol');

Carbon::setLocale(substr(Yii::$app->language, 0, 2)); // eg. en-US to en

// User Preferences
$showFilters = Yii::$app->user->preferences->get('GridView.filters.state') === '1';

$options = array(
    'currentPage' => Url::toRoute(['log', 'id' => $model->id]), // Used by filters
    'gridViewSettingsEndPoint' => Url::to(['/ajax/grid-view-settings']),
);

// Pass php options to javascript
$this->registerJs("var options = ".json_encode($options).";", View::POS_BEGIN, 'form-options');

$gridColumns = [
    [
        'class' => '\kartik\grid\SerialColumn'
    ],
    [
        'class'=>'kartik\grid\ExpandRowColumn',
        'width'=>'50px',
        'value'=>function ($model, $key, $index, $column) {
            return GridView::ROW_COLLAPSED;
        },
        'detail'=>function ($model, $key, $index, $column) {
            return sprintf("<pre>%s</pre>", json_encode(json_decode($model->log), JSON_PRETTY_PRINT));
        },
        'headerOptions'=>['class'=>'kartik-sheet-style'],
        'expandOneOnly'=>true,
    ],
    [
        'attribute'=> 'submission_id',
        'label' => Yii::t('app', 'Submission'),
        'format' => 'raw',
        'value' => function ($model) {
            return isset($model->form_id, $model->submission_id) ?
                Html::a('#' . $model->submission_id, ['/form/submissions', 'id' => $model->form_id, '#' => 'view/'.$model->submission_id ]) :
                null;
        },
    ],
    [
        'class'=>'kartik\grid\BooleanColumn',
        'attribute'=>'status',
        'trueIcon'=>'<span class="glyphicon glyphicon-ok text-success"></span>',
        'falseIcon'=>'<span class="glyphicon glyphicon-remove text-danger"></span>',
        'vAlign'=>'middle',
        'trueLabel' => Yii::t('app', 'Success'),
        'falseLabel' => Yii::t('app', 'Error'),
    ],
    [
        'attribute'=> 'created_at',
        'value' => function ($model) {
            if (!empty($model->created_at)) {
                return Carbon::createFromTimestampUTC($model->created_at)->diffForHumans();
            }
            return null;
        },
        'label' => Yii::t('app', 'Sent'),
        'noWrap'=>true,
        'filterType'=> \kartik\grid\GridView::FILTER_DATE_RANGE,
        'filterWidgetOptions' => [
            'presetDropdown' => false,
            'convertFormat' => true,
            'containerTemplate' => '
        <div class="form-control kv-drp-dropdown">
            <i class="glyphicon glyphicon-calendar"></i>&nbsp;
            <span class="range-value">{value}</span>
            <span><b class="caret"></b></span>
        </div>
        {input}
',
            'pluginOptions' => [
                'showDropdowns' => true,
                'locale' => [
                    'format' => $dateControlModule->getDisplayFormat(DateControlModule::FORMAT_DATE),
                    'separator' => ' - ',
                ],
                'opens' => 'left'
            ]
        ],
    ],
    [
        'attribute'=> 'updated_at',
        'value' => function ($model) {
            if (!empty($model->updated_at)) {
                return Carbon::createFromTimestampUTC($model->updated_at)->diffForHumans();
            }
            return null;
        },
        'label' => Yii::t('app', 'Re-Sent'),
        'noWrap'=>true,
        'filterType'=> \kartik\grid\GridView::FILTER_DATE_RANGE,
        'filterWidgetOptions' => [
            'presetDropdown' => false,
            'convertFormat' => true,
            'containerTemplate' => '
        <div class="form-control kv-drp-dropdown">
            <i class="glyphicon glyphicon-calendar"></i>&nbsp;
            <span class="range-value">{value}</span>
            <span><b class="caret"></b></span>
        </div>
        {input}
',
            'pluginOptions' => [
                'showDropdowns' => true,
                'locale' => [
                    'format' => $dateControlModule->getDisplayFormat(DateControlModule::FORMAT_DATE),
                    'separator' => ' - ',
                ],
                'opens' => 'left'
            ]
        ],
    ],
    ['class' => 'kartik\grid\ActionColumn',
        'dropdown'=>true,
        'dropdownButton' => ['class'=>'btn btn-primary'],
        'dropdownOptions' => ['class' => 'pull-right'],
        'buttons' => [
            //resend button
            'resend' => function ($url) {
                $options = array_merge([
                    'title' => Yii::t('app', 'Re-Send Form Submission'),
                    'aria-label' => Yii::t('app', 'Re-Send Form Submission'),
                    'data-pjax' => '0',
                ], []);
                return '<li>'.Html::a('<span class="glyphicon glyphicon-send"></span> ' .
                        Yii::t('app', 'Re-Send Form Submission'), $url, $options).'</li>';
            },
        ],
        'urlCreator' => function ($action, $model, $key, $index) {
            if ($action == "resend") {
                return Url::to(['resend', 'id' => $model->salesforce_id, 'sid' => $model->submission_id]);
            }
         },
        'template' => '{resend}',
    ],
];

?>
<div class="salesforce-log">
    <div class="row">
        <div class="col-md-12">
            <?= GridView::widget([
                'id' => 'salesforce-grid',
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => $gridColumns,
                'resizableColumns' => false,
                'pjax' => false,
                'export' => false,
                'responsive' => true,
                'bordered' => false,
                'striped' => true,
                'containerOptions' => [
                    'class' => $showFilters ? 'table-with-filters' : '',
                ],
                'panelTemplate' => Html::tag('div', '{panelHeading}{panelBefore}{items}{panelFooter}', [
                    'class' => 'panel {type}']),
                'panel' => [
                    'type'=>GridView::TYPE_INFO,
                    'heading'=> Yii::t('app', 'Salesforce')
                        . ' <small class="panel-subtitle hidden-xs">'
                        . Yii::t('app', 'Log')
                        . '</small>',
                    'before'=> ActionBar::widget([
                        'grid' => 'salesforce-grid',
                        'templates' => Yii::$app->user->can('viewBulkActionsInAddons') ? [
                            '{create}' => ['class' => 'col-xs-6 col-sm-6'],
                            // '{filters}' => ['class' => 'col-xs-6 col-sm-3 col-lg-4'],
                            // '{bulk-actions}' => ['class' => 'col-sm-3 col-lg-2 hidden-xs'],
                            '{filters}' => ['class' => 'col-xs-6 col-sm-6'],
                        ] : [
                            '{create}' => ['class' => 'col-xs-6 col-sm-6'],
                            '{filters}' => ['class' => 'col-xs-6 col-sm-6'],
                        ],
                        'elements' => [
                            'create' =>
                                Html::a(
                                    '<span class="glyphicon glyphicon-arrow-left"></span> ' .
                                    Yii::t('app', 'Back to Index'),
                                    ['index'],
                                    ['class' => 'btn btn-default']
                                ),
                            'filters' => SwitchInput::widget([
                                'name'=>'filters',
                                'type' => SwitchInput::CHECKBOX,
                                'value' => $showFilters,
                                'pluginOptions' => [
                                    'size' => 'mini',
                                    'animate' => false,
                                    'labelText' => Yii::t('app', 'Filter'),
                                ],
                                'pluginEvents' => [
                                    "switchChange.bootstrapSwitch" => "function(event, state) {
                                        var show = (typeof state !== 'undefined' && state == 1) ? 1 : 0;
                                        $.post(options.gridViewSettingsEndPoint, { 'show-filters': show })
                                            .done(function(response) {
                                                if (response.success) {
                                                    if (show) {
                                                        $('.filters').fadeIn();
                                                    } else {
                                                        $('.filters').fadeOut();
                                                        window.location = options.currentPage;
                                                    }                   
                                                }
                                            });
                                        }",
                                ],
                                'containerOptions' => ['style' => 'margin-top: 6px; text-align: right'],
                            ]),
                        ],
                        'bulkActionsItems' => [
                            Yii::t('app', 'Update Status') => [
                                'status-active' => Yii::t('app', 'Active'),
                                'status-inactive' => Yii::t('app', 'Inactive'),
                            ],
                            'General' => ['general-delete' => 'Delete'],
                        ],
                        'bulkActionsOptions' => [
                            'options' => [
                                'status-active' => [
                                    'url' => Url::toRoute(['update-status', 'status' => 1]),
                                ],
                                'status-inactive' => [
                                    'url' => Url::toRoute(['update-status', 'status' => 0]),
                                ],
                                'general-delete' => [
                                    'url' => Url::toRoute('delete-multiple'),
                                    'data-confirm' => Yii::t(
                                        'app',
                                        'Are you sure you want to delete these configurations? All data related to each item will be deleted. This action cannot be undone.'
                                    ),
                                ],
                            ],
                            'class' => 'form-control',
                        ],
                    ]),
                ],
                'replaceTags' => [
                    '{pageSize}' => function($widget) {
                        $html = '';
                        if ($widget->panelFooterTemplate !== false) {
                            $selectedSize = Yii::$app->user->preferences->get('GridView.pagination.pageSize');
                            return PageSizeDropDownList::widget(['selectedSize' => $selectedSize]);
                        }
                        return $html;
                    },
                ],
                'panelFooterTemplate' => '
                        <div class="kv-panel-pager">
                            {pageSize}
                            {pager}
                        </div>
                    ',
                'toolbar' => false
            ]); ?>
        </div>
    </div>
</div>
