<?php

use app\components\widgets\ConditionsBuilder;
use app\helpers\EventHelper;
use app\modules\addons\modules\salesforce\models\Salesforce;
use yii\helpers\Html;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\salesforce\models\Salesforce */
/* @var $fieldModel app\modules\addons\modules\salesforce\models\SalesforceField */
/* @var $form yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */
/* @var $lists array [id => name] of Subscriber Lists */
/* @var $leadSources array [id => name] of Lead Sources */
/* @var $leadStatuses array [id => name] of Lead Statuses */
/* @var $marketingLists array [id => name] of Salesforce Marketing Lists */
/* @var $connected boolean The connection to Salesforce has been established */

$formFieldUrl = Url::to(['/addons/salesforce/admin/fields']);
$listFieldUrl = Url::to(['/addons/salesforce/admin/list-fields']);
?>

<div class="salesforce-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-4">
            <?= $form->field($model, 'username')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-4">
            <?= $form->field($model, 'password')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-4">
            <?= $form->field($model, 'security_token')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <span class="help-block">
                <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                <?= Yii::t(
                    'app',
                    'For connecting to your Salesforce account you need API access.'
                ) ?>
                <?= Html::a(Yii::t('app', 'Go to Salesforce'), 'https://login.salesforce.com', ['target' => '_blank']) ?>.
            </span>
        </div>
    </div>

    <?php if ($connected): ?>

        <div class="row" style="margin-top: 20px;">
            <div class="col-sm-12">
                <?= $form->field($model, 'name')->textInput([
                    'maxlength' => true,
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'form_id')->widget(Select2::class, [
                    'data' => $forms,
                    'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ])->label(Yii::t('app', 'Form')); ?>
            </div>
            <div class="col-sm-6">
                <?= $form->field($model, 'list_id')->widget(Select2::class, [
                    'data' => $lists,
                    'options' => [
                        'placeholder' => Yii::t('app', 'Select a list...'),
                    ],
                    'pluginOptions' => [
                        'allowClear' => true
                    ]
                ])->hint( Yii::t(
                    'app',
                    'Select the list you want to add information to.'
                ))->label(Yii::t('app', 'List')); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'event')->widget(Select2::class, [
                    'data' => EventHelper::supportedFormEvents(),
                ]); ?>
            </div>
            <div class="col-sm-6">
                <?php if ($model->isNewRecord) { $model->status = 1;} ?>
                <?= $form->field($model, 'status')->widget(SwitchInput::class)->hint(Yii::t(
                    'app',
                    'Disables the integration at any time.'
                )) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <?= ConditionsBuilder::widget([
                    'label' => Yii::t('app', 'Conditions'),
                ]) ?>
                <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <legend><?= Yii::t('app', 'Field Mapping') ?></legend>
            </div>
        </div>

        <?php if ($model->isNewRecord || count($model->items) === 0): ?>

            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($fieldModel, '[0]form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['salesforce-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($fieldModel, '[0]list_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['salesforce-list_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $listFieldUrl,
                                'params' => ['salesforce-form_id'],
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-add">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </fieldset>

            <fieldset id="itemTemplate" class="d-none">
                <div class="row">
                    <div class="col-sm-6">
                        <?= $form->field($fieldModel, 'form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['salesforce-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= $form->field($fieldModel, 'list_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['salesforce-list_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $listFieldUrl,
                                'params' => ['salesforce-form_id'],
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-remove">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </fieldset>

        <?php else: ?>

            <?php foreach($model->items as $i => $item): ?>
                <fieldset class="item">
                    <div class="row">
                        <div class="col-sm-6">
                            <?= Html::hiddenInput('item-'.$i.'-form_field',
                                $item->form_field, ['id'=>'item-'.$i.'-form_field']) ?>
                            <?= $form->field($fieldModel, '['.$i.']form_field')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['salesforce-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $formFieldUrl,
                                    'params'=>['item-'.$i.'-form_field'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-5">
                            <?= Html::hiddenInput('item-'.$i.'-list_field', $item->list_field, ['id'=>'item-'.$i.'-list_field']) ?>
                            <?= $form->field($fieldModel, '['.$i.']list_field')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['salesforce-list_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $listFieldUrl,
                                    'params' => ['salesforce-form_id', 'item-'.$i.'-list_field'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-1">
                            <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </fieldset>
            <?php endforeach; ?>

            <fieldset id="itemTemplate" class="d-none">
                <div class="row">
                    <div class="col-sm-6">
                        <?= Html::hiddenInput('item-form_field', '', ['id'=>'item-form_field']) ?>
                        <?= $form->field($fieldModel, 'form_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['salesforce-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $formFieldUrl,
                                'params'=>['item-form_field'],
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-5">
                        <?= Html::hiddenInput('item-list_field', '', ['id'=>'item-list_field']) ?>
                        <?= $form->field($fieldModel, 'list_field')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['salesforce-list_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $listFieldUrl,
                                'params'=>['salesforce-form_id', 'item-list_field'],
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <button type="button" class="btn btn-icon btn-default btn-remove" style="margin-top: 28px;">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </fieldset>

        <?php endif; ?>

        <div class="row">
            <div class="col-sm-12">
                <legend><?= Yii::t('app', 'Advanced Settings') ?></legend>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <?php if ($model->isNewRecord) { $model->action = Salesforce::ACTION_SEARCH_AND_UPDATE_OR_CREATE; } ?>
                <?= $form->field($model, 'action')->widget(Select2::class, [
                    'data' => [
                        Salesforce::ACTION_SEARCH_AND_CREATE => Yii::t('app', 'Search and create'),
                        Salesforce::ACTION_SEARCH_AND_UPDATE => Yii::t('app', 'Search and update'),
                        Salesforce::ACTION_SEARCH_AND_UPDATE_OR_CREATE => Yii::t('app', 'Search and update or create'),
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">
                <?php if ($model->isNewRecord) { $model->search_priority = Salesforce::SEARCH_PRIORITY_BY_CONTACT; } ?>
                <?= $form->field($model, 'search_priority')->widget(Select2::class, [
                    'data' => [
                        Salesforce::SEARCH_PRIORITY_BY_CONTACT => Yii::t('app', 'First contact, then lead'),
                        Salesforce::SEARCH_PRIORITY_BY_LEAD => Yii::t('app', 'First lead, then contact'),
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">
                <?php $model->search_by = 'Email'; ?>
                <?= $form->field($model, 'search_by')->widget(Select2::class, [
                    'data' => [
                        'Email' => Yii::t('app', 'Email'),
                    ],
                ]); ?>
            </div>
            <div class="col-sm-3">
                <?= Html::hiddenInput('email_field', $model->email_field, ['id'=>'email_field']) ?>
                <?= $form->field($model, 'email_field')->widget(DepDrop::class, [
                    'pluginOptions' => [
                        'depends' => ['salesforce-form_id'],
                        'placeholder' => Yii::t('app', 'Select...'),
                        'url' => $formFieldUrl,
                        'params' => ['email_field'],
                        'initialize' => !$model->isNewRecord,
                    ]
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <?= Html::hiddenInput('account_name_field', $model->account_name_field, ['id'=>'account_name_field']) ?>
                <?= $form->field($model, 'account_name_field')->widget(DepDrop::class, [
                    'pluginOptions' => [
                        'depends' => ['salesforce-form_id'],
                        'placeholder' => Yii::t('app', 'Select...'),
                        'url' => $formFieldUrl,
                        'params' => ['account_name_field'],
                        'initialize' => !$model->isNewRecord,
                    ]
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= Html::hiddenInput('first_name_field', $model->first_name_field, ['id'=>'first_name_field']) ?>
                <?= $form->field($model, 'first_name_field')->widget(DepDrop::class, [
                    'pluginOptions' => [
                        'depends' => ['salesforce-form_id'],
                        'placeholder' => Yii::t('app', 'Select...'),
                        'url' => $formFieldUrl,
                        'params' => ['first_name_field'],
                        'initialize' => !$model->isNewRecord,
                    ]
                ]) ?>
            </div>
            <div class="col-sm-3">
                <?= Html::hiddenInput('last_name_field', $model->last_name_field, ['id'=>'last_name_field']) ?>
                <?= $form->field($model, 'last_name_field')->widget(DepDrop::class, [
                    'pluginOptions' => [
                        'depends' => ['salesforce-form_id'],
                        'placeholder' => Yii::t('app', 'Select...'),
                        'url' => $formFieldUrl,
                        'params' => ['last_name_field'],
                        'initialize' => !$model->isNewRecord,
                    ]
                ]) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-3">
                <?php if ($model->isNewRecord) { $model->qualify_lead = Salesforce::OFF;} ?>
                <?= $form->field($model, 'qualify_lead')->widget(SwitchInput::class, [
                    'pluginEvents' => [
                        "switchChange.bootstrapSwitch" => "function(event, state) {
                            if (state == true) {
                                $('.qualifyLead').show();
                            } else {
                                $('.qualifyLead').hide();
                            }
                        }",
                    ],
                ]) ?>
            </div>
            <div class="col-sm-3 qualifyLead" <?php if (!$model->qualify_lead): ?> style="display: none" <?php endif; ?>>
                <?php if ($model->isNewRecord) { $model->create_account = Salesforce::OFF;} ?>
                <?= $form->field($model, 'create_account')->widget(SwitchInput::class) ?>
            </div>
            <div class="col-sm-3 qualifyLead" <?php if (!$model->qualify_lead): ?> style="display: none" <?php endif; ?>>
                <?php if ($model->isNewRecord) { $model->create_contact = Salesforce::OFF;} ?>
                <?= $form->field($model, 'create_contact')->widget(SwitchInput::class) ?>
            </div>
            <div class="col-sm-3 qualifyLead" <?php if (!$model->qualify_lead): ?> style="display: none" <?php endif; ?>>
                <?php if ($model->isNewRecord) { $model->create_opportunity = Salesforce::OFF;} ?>
                <?= $form->field($model, 'create_opportunity')->widget(SwitchInput::class) ?>
            </div>
        </div>

    <?php endif; ?>

    <div class="form-group" style="margin-top: 20px">
        <?= Html::submitButton( !$connected ?
            ' <i class="fas fa-external-link-square me-2"></i> ' . Yii::t('app', 'Connect to Salesforce'):
            ' <i class="fas fa-check me-2"></i> ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#salesforce-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['salesforce-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'salesforce-conditions');

/**
 * Field Mapping
 */

if ($model->isNewRecord || count($model->items) === 0) {
    $script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update name attribute
            cloned
                .find('[name="SalesforceField[form_field]"]')
                    .attr('name', 'SalesforceField[' + item + '][form_field]')
                    .attr('id', 'salesforcefield-' + item + '-form_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['salesforce-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="SalesforceField[list_field]"]')
                    .attr('name', 'SalesforceField[' + item + '][list_field]')
                    .attr('id', 'salesforcefield-' + item + '-list_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['salesforce-list_id'],
                        url: '$listFieldUrl'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

} else {

    $script = <<<JS

$(window).on('load', function() {
    $('#salesforce-form_id').trigger('depdrop.change');
    $('#salesforce-list_id').trigger('depdrop.change');
});

$(document).ready(function(){

    var item = $('.item').length;

    $('.btn-remove').first().removeClass('btn-remove').addClass('btn-add')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);

            // Update name attribute
            cloned
                .find('[name="SalesforceField[form_field]"]')
                    .attr('name', 'SalesforceField[' + item + '][form_field]')
                    .attr('id', 'salesforcefield-' + item + '-form_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['salesforce-form_id'],
                        url: '{$formFieldUrl}'
                    })
                    .end()
                .find('[name="SalesforceField[list_field]"]')
                    .attr('name', 'SalesforceField[' + item + '][list_field]')
                    .attr('id', 'salesforcefield-' + item + '-list_field')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['salesforce-list_id'],
                        url: '{$listFieldUrl}'
                    })
                    .end()

            item++;
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });
  
    // Has Qualify Lead Checkbox
    $('#salesforce-qualify_lead').on('init.bootstrapSwitch', function(event, state) {
        if( this.checked ) {
            $('.qualifyLead').show();
        } else {
            $('.qualifyLead').hide();
        }
    });
    
})

JS;
}

$this->registerJs($script, $this::POS_END);

?>