<?php

namespace app\modules\addons\modules\salesforce\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\modules\addons\modules\salesforce\models\SalesforceLog;

/**
 * SalesforceLogSearch represents the model behind the search form of `app\modules\addons\modules\salesforce\models\SalesforceLog`.
 */
class SalesforceLogSearch extends SalesforceLog
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'salesforce_id', 'form_id', 'submission_id', 'created_by', 'updated_by'], 'integer'],
            [['status', 'log', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = SalesforceLog::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => Yii::$app->user->preferences->get('GridView.pagination.pageSize'),
            ],
            'sort' => [
                'defaultOrder' => [
                    'created_at' => SORT_DESC,
                ]
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // Scope
        if (isset($params['id'])) {
            $this->salesforce_id = $params['id'];
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'form_id' => $this->form_id,
            'submission_id' => $this->submission_id,
            'status' => $this->status,
        ]);

        if (isset($this->created_at) && !empty($this->created_at)) {
            list($start, $end) = explode(" - ", $this->created_at);
            $startAt = strtotime(trim($start));
            // Add +1 day to the endAt
            $endAt = strtotime(trim($end)) + (24 * 60 * 60);
            $query->andFilterWhere(['between', '{{%addon_salesforce_log}}.created_at', $startAt, $endAt]);
        }

        if (isset($this->updated_at) && !empty($this->updated_at)) {
            list($start, $end) = explode(" - ", $this->updated_at);
            $startAt = strtotime(trim($start));
            // Add +1 day to the endAt
            $endAt = strtotime(trim($end)) + (24 * 60 * 60);
            $query->andFilterWhere(['between', '{{%addon_salesforce_log}}.updated_at', $startAt, $endAt]);
        }

        $query->andFilterWhere(['like', 'log', $this->log]);

        return $dataProvider;
    }
}