<?php

namespace app\modules\addons\modules\salesforce\models;

use Yii;

/**
 * This is the model class for table "{{%addon_salesforce_item}}".
 *
 * @property integer $id
 * @property integer $salesforce_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class SalesforceField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_salesforce_field}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['salesforce_id', 'form_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'salesforce_id' => Yii::t('app', 'Salesforce ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSalesforce()
    {
        return $this->hasOne(Salesforce::class,['id'=>'salesforce_id']);
    }
}
