<?php

use yii\db\Migration;

/**
 * Class m200629_014257_update_to_1_2
 */
class m200629_014257_update_to_1_2 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_salesforce}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_salesforce}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_salesforce_field}}', 'salesforce_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_salesforce_field}}', 'salesforce_id');

        $this->dropColumn('{{%addon_salesforce}}', 'event');
        $this->dropColumn('{{%addon_salesforce}}', 'conditions');
    }
}
