<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

use yii\db\Migration;

/**
 * Class m190703_220853_init_addon_salesforce
 */
class m190703_220853_init_addon_salesforce extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_salesforce}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),
            'name' => $this->text()->notNull(),

            // Authorization
            'username' => $this->text()->notNull(),
            'password' => $this->text()->notNull(),
            'security_token' => $this->text()->notNull(),

            // List Information
            'list_id' => $this->text()->notNull(),
            'email_field' => $this->text(),
            'account_name_field' => $this->text(),
            'first_name_field' => $this->text(),
            'last_name_field' => $this->text(),

            // Workflow
            'action' => $this->tinyInteger()->defaultValue(0), // 0. Create 1. Search and Update
            'search_by' => $this->text(), // Entity attribute. E.g. Email
            'search_priority' => $this->tinyInteger()->defaultValue(1), // 1. Contact then Lead 2. Lead them Contact
            'update_duplicated' => $this->tinyInteger()->defaultValue(0), // 0. Create new record 1. Update last record
            'qualify_lead' => $this->boolean()->defaultValue(0),
            'create_account' => $this->boolean()->defaultValue(0),
            'create_contact' => $this->boolean()->defaultValue(0),
            'create_opportunity' => $this->boolean()->defaultValue(0),
            'has_marketing_list' => $this->boolean()->defaultValue(0),
            'marketing_list' => $this->text(), // Campaign Name
            'notes' => $this->text(),

            // Settings
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->text(),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_salesforce_field}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'form_field' => $this->text(),
            'list_field' => $this->text(),
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_salesforce_field}}');
        $this->dropTable('{{%addon_salesforce}}');
    }
}
