<?php

use app\components\widgets\ConditionsBuilder;
use app\components\widgets\ActiveForm;
use app\helpers\EventHelper;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\plivo\models\Sms */
/* @var $form yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */

// Default values
if ($model->isNewRecord) {
    $module = \Yii::$app->controller->module;
    $model->api_key = $module->params['AUTH_ID'];
    $model->api_secret = $module->params['AUTH_TOKEN'];
    $model->text = $module->params['SMS_BODY'];
}
?>

<div class="plivo-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'placeholder' => Yii::t('app', "Enter a configuration name..."),
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'event')->widget(Select2::class, [
                'data' => EventHelper::supportedFormEvents(),
            ]); ?>
        </div>
        <div class="col-sm-3">
            <?php if ($model->isNewRecord) { $model->status = 1;} ?>
            <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= ConditionsBuilder::widget([
                'label' => Yii::t('app', 'Conditions'),
            ]) ?>
            <?= $form->field($model, "conditions", ['options' => ['class' => 'hidden']])->hiddenInput() ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'api_key')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'api_secret')->textInput(['maxlength' => true]) ?>
        </div>
    </div>

    <?php if ($model->isNewRecord): ?>

        <div class="row">
            <div class="col-sm-12">
                <span class="help-block">
                    <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                    <?= Yii::t(
                        'app',
                        'Every message matters.'
                    ) ?>
                    <?= Html::a(Yii::t('app', 'Get your Plivo API keys'), 'https://www.plivo.com/') ?>.
                </span>
            </div>
        </div>

    <?php endif; ?>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'from')->textInput(['maxlength' => true])
                ->hint(Yii::t('app', 'An alphanumeric string giving your sender address.')) ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'to')->textInput(['maxlength' => true])
                ->hint(Yii::t('app', 'A single phone number in international format. To specify multiple recipients, separate each phone number with a comma.')) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'text')->textarea()->hint(Yii::t('app', 'The SMS body')) ?>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton($model->isNewRecord ? Yii::t('app', 'Create') : Yii::t('app', 'Update'), ['class' => $model->isNewRecord ? 'btn btn-primary' : 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#sms-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['sms-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'plivo-conditions');
?>