<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\plivo\models;

use app\components\behaviors\DateTrait;
use app\models\Form;
use app\models\User;
use Yii;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_plivo}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property string $name
 * @property string $conditions
 * @property integer $event
 * @property string $platform
 * @property string $api_key
 * @property string $api_secret
 * @property string $to
 * @property string $from
 * @property integer $status
 * @property string $text
 *
 * @property Form $form
 * @property User $author
 * @property User $lastEditor
 */
class Sms extends \yii\db\ActiveRecord
{
    use DateTrait;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_plivo}}';
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'form_id', 'api_key', 'api_secret', 'to', 'from', 'text'], 'required'],
            [['form_id', 'status', 'event'], 'integer'],
            [['conditions', 'text', 'to', 'from'], 'string'],
            [['name', 'platform', 'api_key', 'api_secret'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'event' => Yii::t('app', 'Event'),
            'platform' => Yii::t('app', 'Platform'),
            'api_key' => Yii::t('app', 'Auth ID'),
            'api_secret' => Yii::t('app', 'Auth Token'),
            'to' => Yii::t('app', 'To'),
            'from' => Yii::t('app', 'From'),
            'status' => Yii::t('app', 'Status'),
            'text' => Yii::t('app', 'Text Message'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }
}
