<?php

use yii\db\Migration;

/**
 * Class m170407_012420_init_addon_sms
 */
class m170407_012420_init_addon_sms extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_plivo}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'platform' => $this->string(191)->notNull()->defaultValue('plivo'),
            'api_key' => $this->text()->notNull(),
            'api_secret' => $this->text()->notNull(),
            'to' => $this->text(),
            'from' => $this->text(),
            'status' => $this->boolean()->notNull()->defaultValue(0),
            'text' => $this->text(),
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_plivo}}');
    }
}
