<?php

use app\themes\next\bundles\WysiwygBundle;
use app\helpers\Html;
use app\helpers\SubmissionHelper;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\pdf\models\PdfTemplate */
/* @var $form yii\widgets\ActiveForm */

WysiwygBundle::register($this);

// Load autocomplete library
$this->registerJsFile('@web/static_files/js/libs/jquery.textcomplete.min.js', ['depends' => WysiwygBundle::class]);

if ($model->isNewRecord) {
    $model->dpi = 96;
    $model->remote_enabled = 1;
    $model->js_enabled = 1;
    $model->orientation = 'P';
    $model->paper_size = 'a4';
}

$previewUrl = Url::to(['template/preview']);

/*
 * Data for Autocomplete
 */
$fields = SubmissionHelper::getFieldsForFieldMapping();
$fieldList = [];
foreach ($fields as $name => $label) {
    array_push($fieldList, [
        "text" => $label,
        "value" => $name
    ]);
}

// PHP options required by form.settings.js
$options = array(
    "fieldList" => $fieldList,
    "fieldListUrl" => Url::to(['/ajax/field-list']),
);

// Pass php options to javascript
$this->registerJs("var options = ".json_encode($options).";", $this::POS_BEGIN, 'pdf-editor-options');

?>

<div class="pdf-template-form">

    <?php $form = ActiveForm::begin([
        'id' => 'pdf-template-form',
    ]); ?>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'name')->textInput([
                'placeholder' => Yii::t('app', 'Enter the template name...'),
            ]) ?>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'filename')->textInput([
                'maxlength' => true,
                'class' => 'form-control placeholder-autocomplete',
            ])->hint(Yii::t('app', 'The name used when saving a PDF (Field Variables are allowed).')); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'html')->textarea(array(
                'rows'=>6,
                'placeholder'=>Yii::t('app', 'Enter the PDF body in HTML format...'),
            )); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?php /* echo $form->field($model, 'html_file')->textInput([
                'placeholder' => Yii::t('app', 'Enter the absolute url to the HTML file...'),
            ]) */ ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'dpi')->textInput([
                'placeholder' => Yii::t('app', 'Adjust the image DPI (Dots Per Inch)'),
            ])->hint(Yii::t('app', 'By default this is set to 96.')) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'password')->textInput([
                'placeholder' => Yii::t('app', 'Enter the password...'),
            ])->hint(Yii::t('app', 'Password protect generated PDFs.')) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'remote_enabled')
                ->widget(SwitchInput::class) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'js_enabled')
                ->widget(SwitchInput::class)?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'orientation')->widget(Select2::class, [
                'data' => $model->orientations,
                'options' => [
                    'multiple' => false,
                    'placeholder' => Yii::t('app', 'Select a orientation...'),
                ],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->hint(Yii::t('app', 'Automatically attach PDF to the selected notifications')); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'paper_size')->widget(Select2::class, [
                'data' => $model->sizes,
                'options' => [
                    'multiple' => false,
                    'placeholder' => Yii::t('app', 'Select a paper size...'),
                ],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->hint(Yii::t('app', 'Set the default paper size used when generating PDFs.')); ?>
        </div>
        <div id="paper_size_width" class="col-sm-3" style="display: none;">
            <?= $form->field($model, 'paper_size_width')->textInput([
                'placeholder' => Yii::t('app', 'Enter the paper size width...'),
            ])->hint(Html::tag('span', '', ['id' => 'pdf-width'])) ?>
        </div>
        <div id="paper_size_height" class="col-sm-3" style="display: none;">
            <?= $form->field($model, 'paper_size_height')->textInput([
                'placeholder' => Yii::t('app', 'Enter the paper size height...'),
            ])->hint(Html::tag('span', '', ['id' => 'pdf-height'])) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="form-group" style="margin-top: 20px">
                <?= Html::submitButton(
                    Yii::t('app', 'Preview'),
                    [
                        'id' => 'previewBtn',
                        'name' => 'preview',
                        'class' => 'btn btn-default',
                         'data-bs-toggle' => 'modal',
                         'data-bs-target' => '#previewModal',
                    ]
                ) ?>
                <?= Html::submitButton($model->isNewRecord ?
                    Yii::t('app', 'Save') :
                    Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
            </div>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

    <!-- Modal -->
    <div class="modal fade" id="previewModal" tabindex="-1" role="dialog" aria-labelledby="previewLabel">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="previewLabel">
                        <?= Yii::t('app', 'PDF Preview') ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="<?= Yii::t('app', 'Close') ?>"></button>
                </div>
                <div class="modal-body">
                    <div id="preview"><?= Yii::t('app', 'Loading...') ?></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-bs-dismiss="modal">
                        <?= Yii::t('app', 'Close') ?>
                    </button>
                </div>
            </div>
        </div>
    </div>

</div>

<?php
$suggestedWidth = Yii::t('app', 'Suggested Width');
$suggestedHeight = Yii::t('app', 'Suggested Height');

$script = <<<JS

    $(document).ready(function() {
        var sizes = function(size) {
            if (size === 'custom') {
                $('#paper_size_width').show();
                $('#paper_size_height').show();
                if (document.getElementById('pdftemplate-html_ifr')) {
                    var iBody = document.getElementById('pdftemplate-html_ifr').contentWindow.document.body;
                    $('#pdf-height').html('{$suggestedHeight}: <strong>' + iBody.offsetHeight + '</strong>');
                    $('#pdf-width').html('{$suggestedWidth}: <strong>' + iBody.offsetWidth + '</strong>');
                }
            } else {
                $('#paper_size_width').hide();
                $('#paper_size_height').hide();
            }
        }
        var paperSizeEl = $('#pdftemplate-paper_size');
        sizes(paperSizeEl.val());
        paperSizeEl.on("select2:select", function(e) { 
            sizes(e.params.data.id);
        });
        paperSizeEl.on("select2:unselect", function() { 
            sizes(false);
        });

        /**
         * Show Wysiwyg editor
         */
        if (typeof tinymce !== 'undefined') {
            var tinymceOptions = {
                selector: '#pdftemplate-html',
                height: 500,
                valid_elements: '*[*]',
                entity_encoding: "raw",
                plugins: 'advlist autolink link image lists charmap print preview hr anchor ' +
                    'searchreplace wordcount visualblocks visualchars code fullscreen fullpage insertdatetime nonbreaking ' +
                    'table directionality paste',
                toolbar: 'undo redo | styleselect | bold italic forecolor backcolor | alignleft aligncenter alignright alignjustify | ltr rtl | bullist numlist outdent indent | hr link image table | preview fullscreen code',
                convert_urls: false,
                setup: function (editor) {
                    editor.ui.registry.addAutocompleter('field-list', {
                        ch: '{',
                        minChars: 0,
                        columns: 1,
                        fetch: function (pattern) {
                            var matchedChars = options.fieldList.filter(function (character) {
                                return character.text.indexOf(pattern) !== -1;
                            });
    
                            return new tinymce.util.Promise(function (resolve) {
                                var results = matchedChars.map(function (character) {
                                    return {
                                        value: "{{ " + character.value + " }} ",
                                        text: character.text,
                                        icon: character.value
                                    }
                                });
                                resolve(results);
                            });
                        },
                        onAction: function (autocompleteApi, rng, value) {
                            editor.selection.setRng(rng);
                            editor.insertContent(value);
                            autocompleteApi.hide();
                        }
                    });
                }
            };
            if ($('body').attr('data-bs-theme') === 'dark') {
                tinymceOptions.skin = 'oxide-dark';
                tinymceOptions.content_css = 'dark';
            }
            tinymce.init(tinymceOptions);
        }

        /**
         * Autocomplete
         */
        $('body').on('click', '.placeholder-autocomplete', function (e) {
            // Add autocomplete suggestions to text format
            var currentTarget = $(e.currentTarget);
            currentTarget
                .textcomplete('destroy');
            currentTarget
                .textcomplete([
                    {
                        match: function () {
                            return /(\.*){(\w*)$/;
                        },
                        search: function (term, callback, match) {
                            $.post(options.fieldListUrl, {
                                term: typeof match[2] === "undefined" ? '' : match[2],
                                _csrf: $('meta[name=csrf-token]').attr('content')
                            })
                                .done(function(response) {
                                    if (typeof response.data === "object") {
                                        var data = Object.keys(response.data).map(function(key) {
                                            var val = {};
                                            val[key] = "<span>" + key + "</span>" + response.data[key];
                                            return val;
                                        });
                                        callback($.map(data, function (f) {
                                            var value = f[Object.keys(f)[0]];
                                            return value.indexOf(term) === 0 ? f : null;
                                        }));
                                    } else {
                                        callback([]);
                                    }
                                });
                        },
                        template: function (f) {
                            return f[Object.keys(f)[0]];
                        },
                        index: 1,
                        replace: function (f) {
                            var key = Object.keys(f)[0];
                            return '{{ ' + key + ' }} ';
                        }
                    }
                ], {
                    zIndex: 1500,
                    maxCount: -1
                });
        });
    
        /**
        * Preview
        */
        $('#previewBtn').on('click', function(e) {
            e.preventDefault();
            if (typeof tinymce !== 'undefined') {
                // Save editor's content
                if (tinyMCE.get(0)) {
                    tinyMCE.triggerSave();
                }
            }
            // Generate PDF
            $.ajax({
                type: "POST",
                url: '{$previewUrl}',
                data: $('#pdf-template-form').serialize(),
                success: function (pdf) {
                    $( "#preview").html('<iframe src="data:application/pdf;base64,' + pdf + '" width="100%" height="500" frameBorder="0" allowtransparency="true"></iframe>');
                }
            });
        });
    });

JS;

$this->registerJs($script, $this::POS_END);
