<?php

use app\components\widgets\ConditionsBuilder;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use yii\helpers\Html;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\pdf\models\Pdf */
/* @var $form \yii\widgets\ActiveForm */
/* @var $forms array [id => name] of Form models */
/* @var $templates array [id => name] of Form models */
/* @var $notifications array [id => name] of Notification Types */
/* @var array $templates [id => name] of PDFTemplate models */
/* @var $pdfTemplates array [id => name] of PdfPdfTemplate models */

?>

<div class="pdf-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'maxlength' => true,
            ])->hint(Yii::t('app', 'Provides a human-readable identifier for this particular PDF configuration.')) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-3">
            <?php $model->status = $model->isNewRecord ? 1 : $model->status; ?>
            <?= $form->field($model, 'status')->widget(SwitchInput::class, [
                'pluginOptions' => [
                    'onColor' => 'primary',
                ],
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?php $model->digital_signature = $model->isNewRecord ? 0 : $model->digital_signature; ?>
            <?= $form->field($model, 'digital_signature')->widget(SwitchInput::class, [
                'pluginOptions' => [
                    'onColor' => 'primary',
                ],
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= Html::label(Yii::t('app', 'PDF Templates')); ?>
            <?= Select2::widget([
                'name' => 'templates',
                'data' => $templates,
                'value' => $pdfTemplates ?? null,
                'options' => ['placeholder' => Yii::t('app', 'Select a PDF template...'), 'multiple' => true],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ]) ?>
            <p class="help-block"><?= Yii::t('app', 'Choose an existing template or {link}.', [
                'link' => Html::a(Yii::t('app', 'create one'), Url::to(['template/create']))
            ]) ?></p>
        </div>
        <div class="col-sm-6">
            <?= $form->field($model, 'notifications')->widget(Select2::class, [
                'data' => $model->notificationTypes,
                'options' => [
                    'multiple' => true,
                    'placeholder' => Yii::t('app', 'Select a notification...'),
                ],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->hint(Yii::t('app', 'Automatically attach PDF to the selected notifications')); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <?= ConditionsBuilder::widget([
                'label' => Yii::t('app', 'Conditions'),
            ]) ?>
            <?= $form->field($model, "conditions", ['options' => ['class' => 'hidden']])->hiddenInput()->label(false) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="form-group" style="margin-top: 20px">
                <?= Html::submitButton($model->isNewRecord ?
                    Yii::t('app', 'Save') :
                    Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
            </div>
        </div>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php
$script = <<<JS

    $(document).ready(function(){

        // Opt In Checkboxes
        $('#pdf-opt_in').on('init.bootstrapSwitch', function(event, state) {
            if( this.checked ) {
                $('#optInField').show();
                $('#optInFieldValue').show();
            } else {
                $('#optInField').hide();
                $('#optInFieldValue').hide();
            }
        });
    });

JS;

$this->registerJs($script, $this::POS_END);

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#pdf-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['pdf-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'pdf-conditions');
