<?php

namespace app\modules\addons\modules\pdf\models;

use app\components\behaviors\DateTrait;
use app\models\User;
use app\modules\addons\modules\pdf\services\PdfService;
use Yii;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_pdf_template}}".
 *
 * @property int $id
 * @property string $name
 * @property string $filename
 * @property string $html
 * @property string $html_file
 * @property string $paper_size
 * @property integer $paper_size_width
 * @property integer $paper_size_height
 * @property string $orientation
 * @property int $remote_enabled
 * @property int $js_enabled
 * @property int $dpi
 * @property string $password
 * @property int $created_by
 * @property int $updated_by
 * @property int $created_at
 * @property int $updated_at
 *
 * @property array $orientations
 * @property array $sizes
 * @property User $author
 * @property User $lastEditor
 */
class PdfTemplate extends \yii\db\ActiveRecord
{
    use DateTrait;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_pdf_template}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'filename', 'html', 'paper_size', 'orientation', 'dpi'], 'required'],
            [['name', 'html', 'html_file', 'paper_size', 'orientation', 'password'], 'string'],
            [['filename'], 'string', 'max' => 2555],
            [['remote_enabled', 'js_enabled', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['paper_size_width', 'paper_size_height', 'dpi'], 'integer', 'min' => 0],
            [['html_file'], 'url', 'defaultScheme' => 'http'],
            // [['html'], 'filter', 'filter' => function ($value) { return HtmlPurifier::process($value); }],
            [['paper_size_width', 'paper_size_height'], 'required', 'when' => function ($model) {
                return $model->paper_size === 'custom';
            }, 'whenClient' => "function (attribute, value) {
                return $('#pdftemplate-paper_size').select2('val') === 'custom';
            }"],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'name' => Yii::t('app', 'Name'),
            'filename' => Yii::t('app', 'Filename'),
            'html' => Yii::t('app', 'HTML Template'),
            'html_file' => Yii::t('app', 'HTML File'),
            'paper_size' => Yii::t('app', 'Paper Size'),
            'paper_size_width' => Yii::t('app', 'Width'),
            'paper_size_height' => Yii::t('app', 'Height'),
            'orientation' => Yii::t('app', 'Orientation'),
            'remote_enabled' => Yii::t('app', 'Images and CSS files'),
            'js_enabled' => Yii::t('app', 'Inline Javascript'),
            'dpi' => Yii::t('app', 'Image DPI'),
            'password' => Yii::t('app', 'Password'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPdfTemplates()
    {
        return $this->hasMany(PdfPdfTemplate::class, ['pdf_template_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPdfs()
    {
        return $this->hasMany(Pdf::class, ['id' => 'pdf_template_id'])
            ->via('pdfTemplates');
    }

    public function getSizes()
    {
        $pdf = new PdfService();
        $sizes = $pdf->getPaperSizes();
        $sizes['custom'] = Yii::t('app', 'Custom Size');
        return $sizes;
    }

    public function getOrientations()
    {
        return [
            'P' => Yii::t('app', 'Portrait'),
            'L' => Yii::t('app', 'Landscape'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }
}
