<?php

namespace app\modules\addons\modules\pdf\models;

use Yii;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "pdf_pdf_template".
 *
 * @property integer $pdf_id
 * @property integer $pdf_template_id
 * @property integer $created_at
 * @property integer $updated_at
 */
class PdfPdfTemplate extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_pdf_pdf_template}}';
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['pdf_id', 'pdf_template_id'], 'required'],
            [['pdf_id', 'pdf_template_id'], 'integer'],
            [['pdf_id', 'pdf_template_id'], 'unique', 'targetAttribute' => ['pdf_id', 'pdf_template_id'],
                'message' => 'The combination of PDF ID and PDF Template ID has already been taken.'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'pdf_id' => Yii::t('app', 'PDF ID'),
            'pdf_template_id' => Yii::t('app', 'PDF Template ID'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPdf()
    {
        return $this->hasOne(Pdf::class, ['id' => 'pdf_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPdfTemplate()
    {
        return $this->hasOne(PdfTemplate::class, ['id' => 'pdf_template_id']);
    }
}
