<?php

namespace app\modules\addons\modules\pdf\models;

use app\components\behaviors\DateTrait;
use app\events\SubmissionMailEvent;
use app\models\Form;
use app\models\User;
use Yii;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_pdf}}".
 *
 * @property int $id
 * @property int $form_id
 * @property string $name
 * @property int $status
 * @property int $digital_signature
 * @property string $conditions
 * @property string $notifications
 * @property int $created_by
 * @property int $updated_by
 * @property int $created_at
 * @property int $updated_at
 *
 * @property Form $form
 * @property PdfPdfTemplate[] $templates
 * @property PdfTemplate[] $selectedTemplates
 * @property array $notificationTypes
 * @property User $author
 * @property User $lastEditor
 */
class Pdf extends \yii\db\ActiveRecord
{
    use DateTrait;

    const ON = 1;
    const OFF = 0;

    /** @var null|array Email Notification Types */
    public $notificationTypes = null;

    /**
     * {@inheritdoc}
     */
    public function init()
    {
        $this->notificationTypes = [
            SubmissionMailEvent::EVENT_TYPE_CONFIRMATION => Yii::t('app', 'Confirmation Email'),
            SubmissionMailEvent::EVENT_TYPE_NOTIFICATION => Yii::t('app', 'Email Notification'),
        ];

        parent::init();
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_pdf}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['form_id', 'name'], 'required'],
            [['form_id', 'status', 'digital_signature'], 'integer'],
            [['conditions'], 'string'],
            [['name'], 'string', 'max' => 2555],
            [['notifications'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form'),
            'name' => Yii::t('app', 'Name'),
            'status' => Yii::t('app', 'Status'),
            'digital_signature' => Yii::t('app', 'Digitally Sign'),
            'conditions' => Yii::t('app', 'Conditions'),
            'notifications' => Yii::t('app', 'Notifications'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getTemplates()
    {
        return $this->hasMany(PdfPdfTemplate::class, ['pdf_id' => 'id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSelectedTemplates()
    {
        return $this->hasMany(PdfTemplate::class, ['id' => 'pdf_template_id'])
            ->via('templates');
    }

    /**
     * @inheritdoc
     */
    public function afterFind()
    {
        $this->notifications = explode(',', $this->notifications);

        parent::afterFind();
    }

    /**
     * @inheritdoc
     */
    public function beforeValidate()
    {
        if (is_array($this->notifications)) {
            $this->notifications = implode(',', $this->notifications);
        }

        return parent::beforeValidate();
    }
}
