<?php

use yii\db\Migration;

/**
 * Class m190808_175524_init_addon_pdf
 */
class m190808_175524_init_addon_pdf extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_pdf}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'name' => $this->text()->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->text(),
            'opt_in_field_value' => $this->text(),

            // Settings
            'template_id' => $this->integer(11),
            'notifications' => $this->text(),

            // Additional Settings
            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),

        ], $tableOptions);

        $this->createTable('{{%addon_pdf_template}}', [
            'id' => $this->primaryKey(),
            'name' => $this->text(),
            'filename' => $this->string(2555),

            // Body
            'html' => $this->text(),
            'html_file' => $this->text(),

            // Settings
            'paper_size' => $this->string(),
            'paper_size_width' => $this->integer(),
            'paper_size_height' => $this->integer(),
            'orientation' => $this->text(),
            'dpi' => $this->integer()->defaultValue(96),
            'password' => $this->text(),
            'js_enabled' => $this->boolean()->defaultValue(0),
            'remote_enabled' => $this->boolean()->defaultValue(0),

            // Additional Settings
            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_pdf_pdf_template}}', [
            'pdf_id' => $this->integer(11)->notNull(),
            'pdf_template_id' => $this->integer(11)->notNull(),
            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createIndex("{{%addon_pdf_pdf_template_pdf_id}}", "{{%addon_pdf_pdf_template}}", "pdf_id");
        $this->createIndex("{{%addon_pdf_pdf_template_pdf_template_id}}", "{{%addon_pdf_pdf_template}}", "pdf_template_id");
        $this->createIndex("{{%addon_pdf_pdf_template_pdf_id_pdf_template_id}}", "{{%addon_pdf_pdf_template}}", ["pdf_id", "pdf_template_id"], true);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropIndex('{{%addon_pdf_pdf_template_pdf_id_pdf_template_id}}', '{{%addon_pdf_pdf_template}}');
        $this->dropIndex('{{%addon_pdf_pdf_template_pdf_template_id}}', '{{%addon_pdf_pdf_template}}');
        $this->dropIndex('{{%addon_pdf_pdf_template_pdf_id}}', '{{%addon_pdf_pdf_template}}');

        $this->dropTable('{{%addon_pdf_pdf_template}}');
        $this->dropTable('{{%addon_pdf_template}}');
        $this->dropTable('{{%addon_pdf}}');
    }

}
