<?php

use yii\helpers\Html;

/* @var $this yii\web\View */
/* @var $model app\modules\addons\modules\paypal_invoicing\models\PaypalInvoicing */
/* @var $itemModel app\modules\addons\modules\paypal_invoicing\models\PaypalInvoicingItem */
/* @var $recipientModel app\modules\addons\modules\paypal_invoicing\models\PaypalInvoicingRecipient */
/* @var $forms array [id => name] of Form models */
/* @var $templates array [id => name] of Paypal Invoice Templates */
/* @var $connected boolean The connection to Paypal Api has been established */

$this->title = Yii::t('app', 'Update Form');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Paypal Invoicing'), 'url' => ['index']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Form') .' #'.
    $model->id, 'url' => ['view', 'id' => $model->id]];
$this->params['breadcrumbs'][] = Yii::t('app', 'Update');

?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?= $this->render('_form', [
                            'model' => $model,
                            'forms' => $forms,
                            'itemModel' => $itemModel,
                            'recipientModel' => $recipientModel,
                            'templates' => $templates,
                            'connected' => $connected,
                        ]) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
