<?php

use Carbon\Carbon;
use yii\web\View;
use yii\helpers\Url;
use yii\helpers\Html;
use app\components\widgets\GridView;
use app\components\widgets\ActionBar;
use kartik\switchinput\SwitchInput;

/* @var $this yii\web\View */
/* @var $searchModel app\modules\addons\modules\paypal_invoicing\models\PaypalInvoicingSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $model app\modules\addons\modules\paypal_invoicing\models\PaypalInvoicing */

$this->title = Yii::t('app', 'PayPal Invoices');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Paypal Invoicing'), 'url' => ['index']];
$this->params['breadcrumbs'][] = Yii::t('app', 'Invoices');


$gridColumns = [
    [
        'class' => '\kartik\grid\SerialColumn'
    ],
    [
        'class'=>'kartik\grid\ExpandRowColumn',
        'width'=>'50px',
        'value'=>function ($model, $key, $index, $column) {
            return GridView::ROW_COLLAPSED;
        },
        'detail'=>function ($model, $key, $index, $column) {
            return sprintf("<pre>%s</pre>", json_encode(json_decode($model->data), JSON_PRETTY_PRINT));
        },
        'headerOptions'=>['class'=>'kartik-sheet-style'],
        'expandOneOnly'=>true,
        'expandIcon' => '<span class="glyphicon glyphicon-expand"></span>',
        'collapseIcon' => '<span class="glyphicon glyphicon-collapse"></span>',
        'expandAllTitle' => Yii::t('app', 'API Response - Expand All'),
        'collapseAllTitle' => Yii::t('app', 'API Response - Collapse All'),
    ],
    [
        'attribute'=> 'submission',
        'label' => Yii::t('app', 'Submission'),
        'format' => 'raw',
        'value' => function ($model) {
            return isset($model->form_id, $model->submission_id) ?
                Html::a('#' . $model->submission_id, ['/form/submissions', 'id' => $model->form_id, '#' => 'view/'.$model->submission_id ]) :
                null;
        },
    ],
    [
        'class'=>'kartik\grid\BooleanColumn',
        'attribute'=>'success',
        'trueIcon'=>'<span class="glyphicon glyphicon-ok text-success"></span>',
        'falseIcon'=>'<span class="glyphicon glyphicon-remove text-danger"></span>',
        'vAlign'=>'middle',
        'trueLabel' => Yii::t('app', 'Success'),
        'falseLabel' => Yii::t('app', 'Failure'),
    ],
    [
        'attribute'=> 'created_at',
        'value' => function ($model) {
            return !empty($model->created_at) ? Carbon::createFromTimestampUTC($model->created_at)->diffForHumans() : null;
        },
        'label' => Yii::t('app', 'Submitted'),
        'filterType'=> \kartik\grid\GridView::FILTER_DATE_RANGE,
        'filterWidgetOptions' => [
            'presetDropdown' => true,
            'convertFormat'=>true,
            'pluginOptions' => [
                'locale'=>[
                    'format'=>'Y-m-d h:i A',
                    'separator'=>' - ',
                ],
                'opens'=>'left'
            ] ,
            'pluginEvents' => [
                "apply.daterangepicker" => "function() { apply_filter('created_at') }",
            ]
        ],
    ],
];

$options = array(
    'currentPage' => Url::toRoute(['invoices', 'id' => $model->id]), // Used by filters
);

// Pass php options to javascript
$this->registerJs("var options = ".json_encode($options).";", View::POS_BEGIN, 'form-options');

?>
<div class="paypal_invoicing-invoices">

    <div class="row">
        <div class="col-md-12">
            <?= GridView::widget([
                'id' => 'paypal_invoicing_invoices-grid',
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => $gridColumns,
                'resizableColumns' => false,
                'pjax' => false,
                'export' => false,
                'responsive' => true,
                'bordered' => false,
                'striped' => true,
                'panelTemplate' => '<div class="panel {type}">
                    {panelHeading}
                    {panelBefore}
                    {items}
                    <div style="text-align: center">{pager}</div>
                </div>',
                'panel' => [
                    'type'=>GridView::TYPE_INFO,
                    'heading'=> $model->form->name . ' <small class="panel-subtitle hidden-xs">'. Yii::t('app', 'PayPal Invoices').'</small>',
                    'footer'=>false,
                    // Visible only for admin user
                    'before'=> (!empty(Yii::$app->user) && Yii::$app->user->can("admin")) ?
                        ActionBar::widget([
                            'grid' => 'paypal_invoicing_invoices-grid',
                            'templates' => [
                                '{back}' => ['class' => 'col-xs-6 col-md-8'],
                                '{filters}' => ['class' => 'col-xs-6 col-md-4'],
                            ],
                            'elements' => [
                                'back' =>
                                    Html::a(
                                        '<span class="glyphicon glyphicon-arrow-left"></span> ' .
                                        Yii::t('app', 'Go Back'),
                                        ['index'],
                                        ['class' => 'btn btn-default']
                                    ),
                                'filters' => SwitchInput::widget(
                                    [
                                        'name'=>'filters',
                                        'type' => SwitchInput::CHECKBOX,
                                        'pluginOptions' => [
                                            'size' => 'mini',
                                            'animate' => false,
                                            'labelText' => Yii::t('app', 'Filter'),
                                        ],
                                        'pluginEvents' => [
                                            "switchChange.bootstrapSwitch" => "function(event, state) {
                                                if (state) {
                                                    $('.filters').fadeIn()
                                                    localStorage.setItem('gridView.filters', 1);
                                                } else {
                                                    $('.filters').fadeOut()
                                                    localStorage.setItem('gridView.filters', 0);
                                                    window.location = options.currentPage;
                                                }
                                            }",
                                        ],
                                        'containerOptions' => ['style' => 'margin-top: 6px; text-align: right'],
                                    ]
                                ),
                            ],
                        ]) : null,
                ],
                'toolbar' => false
            ]); ?>
        </div>
    </div>
</div>

<?php
$js = <<< 'SCRIPT'

$(function () {
    // Filters
    var state = localStorage.getItem('gridView.filters');
    if (typeof state !== undefined && state == 1) {
        $('input[name="filters"]').bootstrapSwitch('state', true);
    } else {
        $('input[name="filters"]').bootstrapSwitch('state', false);
    }
});

SCRIPT;
// Register tooltip/popover initialization javascript
$this->registerJs($js);