<?php

use app\components\widgets\ConditionsBuilder;
use app\helpers\EventHelper;
use yii\helpers\Html;
use yii\helpers\Url;
use app\components\widgets\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\paypal_invoicing\models\PaypalInvoicing */
/* @var $itemModel app\modules\addons\modules\paypal_invoicing\models\PaypalInvoicingItem */
/* @var $recipientModel app\modules\addons\modules\paypal_invoicing\models\PaypalInvoicingRecipient */
/* @var $forms array [id => name] of Form models */
/* @var $connected boolean The connection to CleverReach has been established */

$url = Url::to(['/addons/paypal_invoicing/admin/fields']);
?>

<div class="paypal_invoicing-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-sm-12">
            <?= $form->field($model, 'name')->textInput([
                'placeholder' => Yii::t('app', "Enter a configuration name..."),
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-6">
            <?= $form->field($model, 'form_id')->widget(Select2::class, [
                'data' => $forms,
                'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                'pluginOptions' => [
                    'allowClear' => true
                ],
            ])->label(Yii::t('app', 'Form')); ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'mode')->dropDownList(
                ['sandbox' => 'Sandbox', 'live' => 'Live']
            ) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-3">
            <?= $form->field($model, 'client_id')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'client_secret')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'sandbox_client_id')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
        <div class="col-sm-3">
            <?= $form->field($model, 'sandbox_client_secret')->textInput([
                'maxlength' => true,
            ]) ?>
        </div>
    </div>

    <?php if ($connected): ?>
        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'event')->widget(Select2::class, [
                    'data' => EventHelper::supportedFormEventsInPostRequest(),
                ]); ?>
            </div>
            <div class="col-sm-6">
                <?php if ($model->isNewRecord) { $model->status = 1;} ?>
                <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <?= ConditionsBuilder::widget([
                    'label' => Yii::t('app', 'Conditions'),
                ]) ?>
                <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-6">
                <?= $form->field($model, 'template_id')->widget(Select2::class, [
                    'data' => $templates,
                    'options' => ['placeholder' => Yii::t('app', 'Select a Paypal Invoice Template...')],
                    'pluginOptions' => [
                        'allowClear' => true
                    ],
                ])->label(Yii::t('app', 'Template')); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <legend><?= Yii::t('app', 'Items') ?></legend>
            </div>
        </div>

        <?php if ($model->isNewRecord || count($model->items) === 0): ?>

            <fieldset class="item">
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, '[0]name')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, '[0]description')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, '[0]price')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($itemModel, '[0]quantity')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-add btn-add-item">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, '[0]tax_name')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, '[0]tax_percent')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, '[0]discount_percent')->textInput([
                            'maxlength' => true,
                        ]) ?>
                    </div>
                </div>
            </fieldset>

            <fieldset id="itemTemplate" class="d-none">
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, 'name')->textInput([
                            'maxlength' => true,
                            'disabled' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, 'description')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, 'price')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($itemModel, 'quantity')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-remove btn-remove-item">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, 'tax_name')->textInput([
                            'maxlength' => true,
                            'disabled' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, 'tax_percent')->textInput([
                            'maxlength' => true,
                            'disabled' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, 'discount_percent')->textInput([
                            'maxlength' => true,
                            'disabled' => true,
                        ]) ?>
                    </div>
                </div>
            </fieldset>

        <?php else: ?>

            <?php foreach($model->items as $i => $item): ?>

                <fieldset class="item">
                    <div class="row">
                        <div class="col-sm-3">
                            <?= $form->field($item, '['.$i.']name')->textInput([
                                'maxlength' => true,
                            ]) ?>
                        </div>
                        <div class="col-sm-3">
                            <?= Html::hiddenInput('item-'.$i.'-description',
                                $item->description, ['id'=>'item-'.$i.'-description']) ?>
                            <?= $form->field($itemModel, '['.$i.']description')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['item-'.$i.'-description'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-3">
                            <?= Html::hiddenInput('item-'.$i.'-price',
                                $item->price, ['id'=>'item-'.$i.'-price']) ?>
                            <?= $form->field($itemModel, '['.$i.']price')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['item-'.$i.'-price'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('item-'.$i.'-quantity',
                                $item->quantity, ['id'=>'item-'.$i.'-quantity']) ?>
                            <?= $form->field($itemModel, '['.$i.']quantity')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['item-'.$i.'-quantity'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-1">
                            <div class="form-group" style="padding-top: 28px;">
                                <button type="button" class="btn btn-icon btn-default btn-remove btn-remove-item">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-3">
                            <?= $form->field($item, '['.$i.']tax_name')->textInput([
                                'maxlength' => true,
                            ]) ?>
                        </div>
                        <div class="col-sm-3">
                            <?= $form->field($item, '['.$i.']tax_percent')->textInput([
                                'maxlength' => true,
                            ]) ?>
                        </div>
                        <div class="col-sm-3">
                            <?= $form->field($item, '['.$i.']discount_percent')->textInput([
                                'maxlength' => true,
                            ]) ?>
                        </div>
                    </div>
                </fieldset>

            <?php endforeach; ?>

            <fieldset id="itemTemplate" class="d-none">
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, 'name')->textInput([
                            'maxlength' => true,
                            'disabled' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('item-description', '', ['id'=>'item-description']) ?>
                        <?= $form->field($itemModel, 'description')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['item-description'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('item-price', '', ['id'=>'item-price']) ?>
                        <?= $form->field($itemModel, 'price')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['item-price'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('item-quantity', '', ['id'=>'item-quantity']) ?>
                        <?= $form->field($itemModel, 'quantity')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'initialize' => true,
                                'params'=>['item-quantity'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-remove btn-remove-item">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, 'tax_name')->textInput([
                            'maxlength' => true,
                            'disabled' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, 'tax_percent')->textInput([
                            'maxlength' => true,
                            'disabled' => true,
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($itemModel, 'discount_percent')->textInput([
                            'maxlength' => true,
                            'disabled' => true,
                        ]) ?>
                    </div>
                </div>
            </fieldset>

        <?php endif; ?>

        <div class="row">
            <div class="col-sm-12">
                <legend><?= Yii::t('app', 'Recipients') ?></legend>
            </div>
        </div>

        <?php if ($model->isNewRecord || count($model->recipients) === 0): ?>

            <fieldset class="recipient">
                <h4><?= Yii::t('app', 'Billing Info') ?></h4>
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($recipientModel, '[0]billing_email_address')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($recipientModel, '[0]billing_language')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($recipientModel, '[0]billing_name')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]billing_surname')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-add btn-add-recipient">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]billing_address_line_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]billing_admin_area_2')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]billing_admin_area_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]billing_postal_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]billing_country_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]billing_phone_country_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]billing_phone_national_number')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]billing_phone_type')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]billing_additional_value')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                </div>

                <h4><?= Yii::t('app', 'Shipping Info') ?></h4>

                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($recipientModel, '[0]shipping_name')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($recipientModel, '[0]shipping_surname')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]shipping_address_line_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]shipping_admin_area_2')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]shipping_admin_area_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]shipping_postal_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, '[0]shipping_country_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ]
                        ]) ?>
                    </div>
                </div>

            </fieldset>

            <fieldset id="recipientTemplate" class="d-none">
                <h4><?= Yii::t('app', 'Billing Info') ?></h4>
                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($recipientModel, 'billing_email_address')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($recipientModel, 'billing_language')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($recipientModel, 'billing_name')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'billing_surname')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-remove btn-remove-recipient">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'billing_address_line_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'billing_admin_area_2')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'billing_admin_area_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'billing_postal_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'billing_country_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'billing_phone_country_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'billing_phone_national_number')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'billing_phone_type')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'billing_additional_value')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                </div>

                <h4><?= Yii::t('app', 'Shipping Info') ?></h4>

                <div class="row">
                    <div class="col-sm-3">
                        <?= $form->field($recipientModel, 'shipping_name')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= $form->field($recipientModel, 'shipping_surname')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'shipping_address_line_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'shipping_admin_area_2')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'shipping_admin_area_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'shipping_postal_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($recipientModel, 'shipping_country_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                </div>

            </fieldset>

        <?php else: ?>

            <?php foreach($model->recipients as $i => $recipient): ?>

                <fieldset class="recipient">
                    <h4><?= Yii::t('app', 'Billing Info') ?></h4>
                    <div class="row">
                        <div class="col-sm-3">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_email_address',
                                $recipient->billing_email_address, ['id'=>'recipient-'.$i.'-billing_email_address']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_email_address')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_email_address'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-3">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_language',
                                $recipient->billing_language, ['id'=>'recipient-'.$i.'-billing_language']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_language')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_language'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-3">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_name',
                                $recipient->billing_name, ['id'=>'recipient-'.$i.'-billing_name']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_name')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_name'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_surname',
                                $recipient->billing_surname, ['id'=>'recipient-'.$i.'-billing_surname']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_surname')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_surname'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-1">
                            <div class="form-group" style="padding-top: 28px;">
                                <button type="button" class="btn btn-icon btn-default btn-remove btn-remove-recipient">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_address_line_1',
                                $recipient->billing_address_line_1, ['id'=>'recipient-'.$i.'-billing_address_line_1']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_address_line_1')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_address_line_1'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_admin_area_2',
                                $recipient->billing_admin_area_2, ['id'=>'recipient-'.$i.'-billing_admin_area_2']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_admin_area_2')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_admin_area_2'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_admin_area_1',
                                $recipient->billing_admin_area_1, ['id'=>'recipient-'.$i.'-billing_admin_area_1']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_admin_area_1')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_admin_area_1'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_postal_code',
                                $recipient->billing_postal_code, ['id'=>'recipient-'.$i.'-billing_postal_code']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_postal_code')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_postal_code'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_country_code',
                                $recipient->billing_country_code, ['id'=>'recipient-'.$i.'-billing_country_code']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_country_code')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_country_code'],
                                ]
                            ]) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_phone_country_code',
                                $recipient->billing_phone_country_code, ['id'=>'recipient-'.$i.'-billing_phone_country_code']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_phone_country_code')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_phone_country_code'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_phone_national_number',
                                $recipient->billing_phone_national_number, ['id'=>'recipient-'.$i.'-billing_phone_national_number']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_phone_national_number')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_phone_national_number'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_phone_type',
                                $recipient->billing_phone_type, ['id'=>'recipient-'.$i.'-billing_phone_type']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_phone_type')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_phone_type'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-billing_additional_value',
                                $recipient->billing_additional_value, ['id'=>'recipient-'.$i.'-billing_additional_value']) ?>
                            <?= $form->field($recipientModel, '['.$i.']billing_additional_value')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-billing_additional_value'],
                                ]
                            ]) ?>
                        </div>
                    </div>

                    <h4><?= Yii::t('app', 'Shipping Info') ?></h4>

                    <div class="row">
                        <div class="col-sm-3">
                            <?= Html::hiddenInput('recipient-'.$i.'-shipping_name',
                                $recipient->shipping_name, ['id'=>'recipient-'.$i.'-shipping_name']) ?>
                            <?= $form->field($recipientModel, '['.$i.']shipping_name')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-shipping_name'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-3">
                            <?= Html::hiddenInput('recipient-'.$i.'-shipping_surname',
                                $recipient->shipping_surname, ['id'=>'recipient-'.$i.'-shipping_surname']) ?>
                            <?= $form->field($recipientModel, '['.$i.']shipping_surname')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-shipping_surname'],
                                ]
                            ]) ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-shipping_address_line_1',
                                $recipient->shipping_address_line_1, ['id'=>'recipient-'.$i.'-shipping_address_line_1']) ?>
                            <?= $form->field($recipientModel, '['.$i.']shipping_address_line_1')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-shipping_address_line_1'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-shipping_admin_area_2',
                                $recipient->shipping_admin_area_2, ['id'=>'recipient-'.$i.'-shipping_admin_area_2']) ?>
                            <?= $form->field($recipientModel, '['.$i.']shipping_admin_area_2')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-shipping_admin_area_2'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-shipping_admin_area_1',
                                $recipient->shipping_admin_area_1, ['id'=>'recipient-'.$i.'-shipping_admin_area_1']) ?>
                            <?= $form->field($recipientModel, '['.$i.']shipping_admin_area_1')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-shipping_admin_area_1'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-shipping_postal_code',
                                $recipient->shipping_postal_code, ['id'=>'recipient-'.$i.'-shipping_postal_code']) ?>
                            <?= $form->field($recipientModel, '['.$i.']shipping_postal_code')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-shipping_postal_code'],
                                ]
                            ]) ?>
                        </div>
                        <div class="col-sm-2">
                            <?= Html::hiddenInput('recipient-'.$i.'-shipping_country_code',
                                $recipient->shipping_country_code, ['id'=>'recipient-'.$i.'-shipping_country_code']) ?>
                            <?= $form->field($recipientModel, '['.$i.']shipping_country_code')->widget(DepDrop::class, [
                                'pluginOptions' => [
                                    'depends' => ['paypalinvoicing-form_id'],
                                    'placeholder' => Yii::t('app', 'Select...'),
                                    'url' => $url,
                                    'params'=>['recipient-'.$i.'-shipping_country_code'],
                                ]
                            ]) ?>
                        </div>
                    </div>

                </fieldset>

            <?php endforeach; ?>

            <fieldset id="recipientTemplate" class="d-none">
                <h4><?= Yii::t('app', 'Billing Info') ?></h4>
                <div class="row">
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('recipient-billing_email_address',
                            '', ['id'=>'recipient-billing_email_address']) ?>
                        <?= $form->field($recipientModel, 'billing_email_address')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_email_address'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('recipient-billing_language',
                            '', ['id'=>'recipient-billing_language']) ?>
                        <?= $form->field($recipientModel, 'billing_language')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_language'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('recipient-billing_name',
                            '', ['id'=>'recipient-billing_name']) ?>
                        <?= $form->field($recipientModel, 'billing_name')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_name'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-billing_surname',
                            '', ['id'=>'recipient-billing_surname']) ?>
                        <?= $form->field($recipientModel, 'billing_surname')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_surname'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-1">
                        <div class="form-group" style="padding-top: 28px;">
                            <button type="button" class="btn btn-icon btn-default btn-remove btn-remove-recipient">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-billing_address_line_1',
                            '', ['id'=>'recipient-billing_address_line_1']) ?>
                        <?= $form->field($recipientModel, 'billing_address_line_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_address_line_1'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-billing_admin_area_2',
                            '', ['id'=>'recipient-billing_admin_area_2']) ?>
                        <?= $form->field($recipientModel, 'billing_admin_area_2')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_admin_area_2'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-billing_admin_area_1',
                            '', ['id'=>'recipient-billing_admin_area_1']) ?>
                        <?= $form->field($recipientModel, 'billing_admin_area_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_admin_area_1'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-billing_postal_code',
                            '', ['id'=>'recipient-billing_postal_code']) ?>
                        <?= $form->field($recipientModel, 'billing_postal_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_postal_code'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-billing_country_code',
                            '', ['id'=>'recipient-billing_country_code']) ?>
                        <?= $form->field($recipientModel, 'billing_country_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_country_code'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-billing_phone_country_code',
                            '', ['id'=>'recipient-billing_phone_country_code']) ?>
                        <?= $form->field($recipientModel, 'billing_phone_country_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_phone_country_code'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-billing_phone_national_number',
                            '', ['id'=>'recipient-billing_phone_national_number']) ?>
                        <?= $form->field($recipientModel, 'billing_phone_national_number')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_phone_national_number'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-billing_phone_type',
                            '', ['id'=>'recipient-billing_phone_type']) ?>
                        <?= $form->field($recipientModel, 'billing_phone_type')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_phone_type'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-billing_additional_value',
                            '', ['id'=>'recipient-billing_additional_value']) ?>
                        <?= $form->field($recipientModel, 'billing_additional_value')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-billing_additional_value'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                </div>

                <h4><?= Yii::t('app', 'Shipping Info') ?></h4>

                <div class="row">
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('recipient-shipping_name',
                            '', ['id'=>'recipient-shipping_name']) ?>
                        <?= $form->field($recipientModel, 'shipping_name')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-shipping_name'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-3">
                        <?= Html::hiddenInput('recipient-shipping_surname',
                            '', ['id'=>'recipient-shipping_surname']) ?>
                        <?= $form->field($recipientModel, 'shipping_surname')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-shipping_surname'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-shipping_address_line_1',
                            '', ['id'=>'recipient-shipping_address_line_1']) ?>
                        <?= $form->field($recipientModel, 'shipping_address_line_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-shipping_address_line_1'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-shipping_admin_area_2',
                            '', ['id'=>'recipient-shipping_admin_area_2']) ?>
                        <?= $form->field($recipientModel, 'shipping_admin_area_2')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-shipping_admin_area_2'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-shipping_admin_area_1',
                            '', ['id'=>'recipient-shipping_admin_area_1']) ?>
                        <?= $form->field($recipientModel, 'shipping_admin_area_1')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-shipping_admin_area_1'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-shipping_postal_code',
                            '', ['id'=>'recipient-shipping_postal_code']) ?>
                        <?= $form->field($recipientModel, 'shipping_postal_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-shipping_postal_code'],
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                    <div class="col-sm-2">
                        <?= Html::hiddenInput('recipient-shipping_country_code',
                            '', ['id'=>'recipient-shipping_country_code']) ?>
                        <?= $form->field($recipientModel, 'shipping_country_code')->widget(DepDrop::class, [
                            'pluginOptions' => [
                                'depends' => ['paypalinvoicing-form_id'],
                                'placeholder' => Yii::t('app', 'Select...'),
                                'url' => $url,
                                'params'=>['recipient-shipping_country_code'],
                                'initialize' => true,
                            ],
                            'pluginEvents' => [
                                "depdrop:afterChange" => "function(event, id, value) { 
                                    $(event.currentTarget).attr('disabled', true)
                                }",
                            ],
                        ]) ?>
                    </div>
                </div>

            </fieldset>

        <?php endif; ?>

    <?php endif; ?>

    <div class="form-group" style="margin-top: 10px">
        <?= Html::submitButton( !$connected ?
            ' <i class="fas fa-external-link-square me-2"></i> ' . Yii::t('app', 'Connect to Paypal'):
            ' <i class="fas fa-check me-2"></i> ' . Yii::t('app', 'Save'), ['class' => 'btn btn-primary']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>

<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

if ($connected) {


    $ruleBuilderURL = Url::to(['/form/rule-builder']);
    $initialize = (int)!$model->isNewRecord;

    $script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#paypalinvoicing-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['paypalinvoicing-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

    $this->registerJs($script, $this::POS_END, 'paypal_invoicing-conditions');

}

/**
 * Field Mapping
 */

if ($model->isNewRecord || count($model->items) === 0) {

    $script = <<<JS

$(document).ready(function(){    
    
    var item = 0;
    var recipient = 0;

    $('form')
        // Add Item button click handler
        .on('click', '.btn-add-item', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="PaypalInvoicingItem[name]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][name]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-name')
                    .removeAttr('disabled')
                    .end()
                .find('[name="PaypalInvoicingItem[description]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][description]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-description')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingItem[price]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][price]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-price')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingItem[quantity]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][quantity]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-quantity')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingItem[tax_name]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][tax_name]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-tax_name')
                    .removeAttr('disabled')
                    .end()
                .find('[name="PaypalInvoicingItem[tax_percent]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][tax_percent]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-tax_percent')
                    .removeAttr('disabled')
                    .end()
                .find('[name="PaypalInvoicingItem[discount_percent]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][discount_percent]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-discount_percent')
                    .removeAttr('disabled')
                    .end()
        })
        // Add Recipient button click handler
        .on('click', '.btn-add-recipient', function() {

            var template = $('#recipientTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('recipient')
                    .removeAttr('id')
                    .insertBefore(template);
            recipient++;

            // Update the name attributes
            cloned
                .find('[name="PaypalInvoicingRecipient[billing_email_address]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_email_address]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_email_address')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_language]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_language]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_language')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_name]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_name]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_name')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_surname]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_surname]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_surname')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_address_line_1]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_address_line_1]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_address_line_1')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_admin_area_2]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_admin_area_2]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_admin_area_2')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_admin_area_1]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_admin_area_1]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_admin_area_1')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_postal_code]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_postal_code]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_postal_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_country_code]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_country_code]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_country_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_phone_country_code]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_phone_country_code]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_phone_country_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_phone_national_number]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_phone_national_number]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_phone_national_number')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_phone_type]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_phone_type]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_phone_type')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_additional_value]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_additional_value]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_additional_value')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_name]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_name]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_name')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_surname]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_surname]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_surname')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_address_line_1]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_address_line_1]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_address_line_1')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_admin_area_2]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_admin_area_2]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_admin_area_2')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_admin_area_1]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_admin_area_1]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_admin_area_1')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_postal_code]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_postal_code]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_postal_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_country_code]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_country_code]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_country_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()                
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;

    $this->registerJs($script, $this::POS_END);

} else {

    $script = <<<JS

    $(window).on('load', function() {
        $('#paypalinvoicing-form_id').trigger('depdrop.change');
    });

    var item = $('.item').length;
    var recipient = $('.recipient').length;

    $('.btn-remove-item').first().removeClass('btn-remove btn-remove-item').addClass('btn-add btn-add-item')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('.btn-remove-recipient').first().removeClass('btn-remove btn-remove-recipient').addClass('btn-add btn-add-recipient')
        .find('.fa-minus').removeClass('fa-minus').addClass('fa-plus');

    $('form')
        // Add Item button click handler
        .on('click', '.btn-add-item', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="PaypalInvoicingItem[name]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][name]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-name')
                    .removeAttr('disabled')
                    .end()
                .find('[name="PaypalInvoicingItem[description]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][description]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-description')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingItem[price]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][price]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-price')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingItem[quantity]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][quantity]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-quantity')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingItem[tax_name]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][tax_name]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-tax_name')
                    .removeAttr('disabled')
                    .end()
                .find('[name="PaypalInvoicingItem[tax_percent]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][tax_percent]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-tax_percent')
                    .removeAttr('disabled')
                    .end()
                .find('[name="PaypalInvoicingItem[discount_percent]"]')
                    .attr('name', 'PaypalInvoicingItem[' + item + '][discount_percent]')
                    .attr('id', 'paypalinvoicingitem-' + item + '-discount_percent')
                    .removeAttr('disabled')
                    .end()
        })
        // Add Recipient button click handler
        .on('click', '.btn-add-recipient', function() {

            var template = $('#recipientTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('recipient')
                    .removeAttr('id')
                    .insertBefore(template);
            recipient++;

            // Update the name attributes
            cloned
                .find('[name="PaypalInvoicingRecipient[billing_email_address]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_email_address]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_email_address')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_language]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_language]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_language')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_name]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_name]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_name')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_surname]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_surname]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_surname')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_address_line_1]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_address_line_1]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_address_line_1')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_admin_area_2]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_admin_area_2]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_admin_area_2')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_admin_area_1]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_admin_area_1]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_admin_area_1')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_postal_code]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_postal_code]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_postal_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_country_code]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_country_code]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_country_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_phone_country_code]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_phone_country_code]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_phone_country_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_phone_national_number]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_phone_national_number]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_phone_national_number')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_phone_type]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_phone_type]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_phone_type')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[billing_additional_value]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][billing_additional_value]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-billing_additional_value')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_name]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_name]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_name')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_surname]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_surname]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_surname')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_address_line_1]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_address_line_1]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_address_line_1')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_admin_area_2]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_admin_area_2]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_admin_area_2')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_admin_area_1]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_admin_area_1]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_admin_area_1')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_postal_code]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_postal_code]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_postal_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()
                .find('[name="PaypalInvoicingRecipient[shipping_country_code]"]')
                    .attr('name', 'PaypalInvoicingRecipient[' + recipient + '][shipping_country_code]')
                    .attr('id', 'paypalinvoicingrecipient-' + recipient + '-shipping_country_code')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypalinvoicing-form_id'],
                        url: '{$url}'
                    })
                    .end()                
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

JS;

    $this->registerJs($script, $this::POS_END);

}

?>
