<?php

namespace app\modules\addons\modules\paypal_invoicing\services;

class PaypalInvoicingRestApi
{
    protected $authorization;

    protected $baseUrl;

    public function setBaseUrl($baseUrl)
    {
        $this->baseUrl = $baseUrl;
    }

    public function setAuthorization($accessToken)
    {
        $this->authorization = "Authorization: Bearer {$accessToken}";
    }

    public function getCredentials($baseUrl, $clientId, $clientSecret)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $baseUrl . "/v1/oauth2/token");
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSLVERSION , 6);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERPWD, $clientId.":".$clientSecret);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    public function get($resource)
    {

        $url = (strpos($resource, "http://") === 0 || strpos($resource, "https://") === 0 ) ?
            $resource : $this->baseUrl . $resource;

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSLVERSION , 6);
        curl_setopt($ch, CURLOPT_POST, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array($this->authorization));

        $result = curl_exec($ch);

        curl_close($ch);

        return $result;
    }

    public function post($resource, $data = array())
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->baseUrl . $resource);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSLVERSION , 6);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data, true));
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', $this->authorization));

        $result = curl_exec($ch);

        if(curl_errno($ch)){
            echo 'Request Error:' . curl_error($ch);
        }

        curl_close($ch);

        return $result;
    }
}