<?php

namespace app\modules\addons\modules\paypal_invoicing\models;

use Yii;

/**
 * This is the model class for table "{{%addon_paypal_invoicing_recipient}}".
 *
 * @property int $id
 * @property int $paypal_invoicing_id
 * @property int $form_id
 * @property string $billing_name
 * @property string $billing_surname
 * @property string $billing_address_line_1
 * @property string $billing_admin_area_2
 * @property string $billing_admin_area_1
 * @property string $billing_postal_code
 * @property string $billing_country_code
 * @property string $billing_email_address
 * @property string $billing_phone_country_code
 * @property string $billing_phone_national_number
 * @property string $billing_phone_type
 * @property string $billing_additional_value
 * @property string $billing_language
 * @property string $shipping_name
 * @property string $shipping_surname
 * @property string $shipping_address_line_1
 * @property string $shipping_admin_area_2
 * @property string $shipping_admin_area_1
 * @property string $shipping_postal_code
 * @property string $shipping_country_code
 */
class PaypalInvoicingRecipient extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_paypal_invoicing_recipient}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['paypal_invoicing_id', 'form_id'], 'integer'],
            [['billing_email_address'], 'required'],
            [['billing_language', 'billing_additional_value'], 'string'],
            [['billing_name', 'billing_surname', 'billing_address_line_1', 'billing_admin_area_2', 'billing_admin_area_1', 'billing_email_address', 'billing_phone_country_code', 'billing_phone_national_number', 'billing_phone_type', 'shipping_name', 'shipping_surname', 'shipping_address_line_1', 'shipping_admin_area_2', 'shipping_admin_area_1'], 'string', 'max' => 255],
            [['billing_postal_code', 'shipping_postal_code'], 'string', 'max' => 10],
            [['billing_country_code', 'shipping_country_code'], 'string', 'max' => 5],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'paypal_invoicing_id' => Yii::t('app', 'Paypal Invoicing ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'billing_email_address' => Yii::t('app', 'Email Address'),
            'billing_language' => Yii::t('app', 'Language'),
            'billing_name' => Yii::t('app', 'Name'),
            'billing_surname' => Yii::t('app', 'Surname'),
            'billing_address_line_1' => Yii::t('app', 'Address Line 1'),
            'billing_admin_area_2' => Yii::t('app', 'Admin Area 2'),
            'billing_admin_area_1' => Yii::t('app', 'Admin Area 1'),
            'billing_postal_code' => Yii::t('app', 'Postal Code'),
            'billing_country_code' => Yii::t('app', 'Country Code'),
            'billing_phone_country_code' => Yii::t('app', 'Phone Country Code'),
            'billing_phone_national_number' => Yii::t('app', 'Phone Number'),
            'billing_phone_type' => Yii::t('app', 'Phone Type'),
            'billing_additional_value' => Yii::t('app', 'Additional Value'),
            'shipping_name' => Yii::t('app', 'Name'),
            'shipping_surname' => Yii::t('app', 'Surname'),
            'shipping_address_line_1' => Yii::t('app', 'Address Line 1'),
            'shipping_admin_area_2' => Yii::t('app', 'Admin Area 2'),
            'shipping_admin_area_1' => Yii::t('app', 'Admin Area 1'),
            'shipping_postal_code' => Yii::t('app', 'Postal Code'),
            'shipping_country_code' => Yii::t('app', 'Country Code'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaypalInvoicing()
    {
        return $this->hasOne(PaypalInvoicing::class,['id'=>'paypal_invoicing_id']);
    }
}
