<?php

namespace app\modules\addons\modules\paypal_invoicing\models;

use Yii;

/**
 * This is the model class for table "{{%addon_paypal_invoicing_item}}".
 *
 * @property int $id
 * @property int $form_id
 * @property int $paypal_invoicing_id
 * @property string $name
 * @property string $description
 * @property string $quantity
 * @property string $price
 * @property string $tax_name
 * @property string $tax_percent
 * @property string $discount_percent
 */
class PaypalInvoicingItem extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_paypal_invoicing_item}}';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['form_id', 'paypal_invoicing_id'], 'integer'],
            [['name', 'price'], 'required'],
            [['description', 'quantity', 'price', 'tax_name', 'tax_percent', 'discount_percent'], 'string', 'max' => 255],
            [['name'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'paypal_invoicing_id' => Yii::t('app', 'Paypal Invoicing ID'),
            'name' => Yii::t('app', 'Name'),
            'description' => Yii::t('app', 'Description'),
            'quantity' => Yii::t('app', 'Quantity / Hours'),
            'price' => Yii::t('app', 'Price / Rate / Amount'),
            'tax_name' => Yii::t('app', 'Tax Name'),
            'tax_percent' => Yii::t('app', 'Tax Percent'),
            'discount_percent' => Yii::t('app', 'Discount Percent'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaypalInvoicing()
    {
        return $this->hasOne(PaypalInvoicing::class,['id'=>'paypal_invoicing_id']);
    }
}
