<?php

namespace app\modules\addons\modules\paypal_invoicing\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * PaypalInvoicingInvoiceSearch represents the model behind the search form about 'PaypalInvoicingInvoice'`.
 */
class PaypalInvoicingInvoiceSearch extends PaypalInvoicingInvoice
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'form_id', 'paypal_invoicing_id', 'submission_id', 'success', 'created_at', 'updated_at'], 'integer'],
            [['data', 'success', 'status'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = PaypalInvoicingInvoice::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => Yii::$app->params['GridView.pagination.pageSize'],
            ],
            'sort' => [
                'defaultOrder' => [
                    'updated_at' => SORT_DESC,
                ]
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // Add Scope
        if (isset($params['id'])) {
            $this->paypal_invoicing_id = $params['id'];
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'form_id' => $this->form_id,
            'submission_id' => $this->submission_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

        $query->andFilterWhere(['like', 'status', $this->status]);

        return $dataProvider;
    }
}