<?php

namespace app\modules\addons\modules\paypal_invoicing\models;

use Yii;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_paypal_invoicing_invoice}}".
 *
 * @property int $id
 * @property int $form_id
 * @property int $paypal_invoicing_id
 * @property int $submission_id
 * @property string $status
 * @property string $success
 * @property string $data
 * @property int $created_at
 * @property int $updated_at
 */
class PaypalInvoicingInvoice extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_paypal_invoicing_invoice}}';
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            TimestampBehavior::class,
        ];
    }
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['form_id', 'paypal_invoicing_id', 'submission_id', 'success', 'created_at', 'updated_at'], 'integer'],
            [['data', 'success'], 'required'],
            [['data'], 'string'],
            [['status'], 'string', 'max' => 255],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'paypal_invoicing_id' => Yii::t('app', 'Paypal Invoicing ID'),
            'submission_id' => Yii::t('app', 'Submission ID'),
            'status' => Yii::t('app', 'Status'),
            'data' => Yii::t('app', 'Data'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaypalInvoicing()
    {
        return $this->hasOne(PaypalInvoicing::class,['id'=>'paypal_invoicing_id']);
    }
}
