<?php

namespace app\modules\addons\modules\paypal_invoicing\models;

use app\components\behaviors\DateTrait;
use app\models\User;
use Yii;
use app\models\Form;
use app\components\behaviors\RelationTrait;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_paypal_invoicing}}".
 *
 * @property int $id
 * @property int $form_id
 * @property int $status
 * @property string $name
 * @property string $conditions
 * @property integer $event
 * @property string $mode
 * @property string $client_id
 * @property string $client_secret
 * @property string $oauth
 * @property string $sandbox_client_id
 * @property string $sandbox_client_secret
 * @property string $sandbox_oauth
 * @property string $reference
 * @property string $currency_code
 * @property string $note
 * @property string $term
 * @property string $memo
 * @property string $payment_term_type
 * @property string $payment_term_due_date
 * @property string $invoicer_given_name
 * @property string $invoicer_given_surname
 * @property string $invoicer_address_line_1
 * @property string $invoicer_address_line_2
 * @property string $invoicer_admin_area_2
 * @property string $invoicer_admin_area_1
 * @property string $invoicer_postal_code
 * @property string $invoicer_country_code
 * @property string $invoicer_email_address
 * @property string $invoicer_phone_country_code
 * @property string $invoicer_phone_national_number
 * @property string $invoicer_phone_type
 * @property string $invoicer_website
 * @property string $invoicer_tax_id
 * @property string $invoicer_logo_url
 * @property string $invoicer_additional_notes
 * @property int $allow_partial_payment
 * @property string $minimum_amount_due_currency_code
 * @property string $minimum_amount_due_value
 * @property int $allow_tip
 * @property int $tax_calculated_after_discount
 * @property int $tax_inclusive
 * @property string $template_id
 * @property string $amount_breakdown_custom_label
 * @property string $amount_breakdown_custom_amount_currency_code
 * @property string $amount_breakdown_custom_amount_value
 * @property string $amount_breakdown_shipping_amount_currency_code
 * @property string $amount_breakdown_shipping_amount_value
 * @property string $amount_breakdown_shipping_tax_name
 * @property string $amount_breakdown_shipping_tax_percent
 * @property int $amount_breakdown_invoice_discount_percent
 * @property int $created_by
 * @property int $updated_by
 * @property int $created_at
 * @property int $updated_at
 *
 * @property Form $form
 * @property PaypalInvoicingRecipient[] $recipients
 * @property PaypalInvoicingItem[] $items
 * @property PaypalInvoicingInvoice[] $invoices
 * @property User $author
 * @property User $lastEditor
 */
class PaypalInvoicing extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return '{{%addon_paypal_invoicing}}';
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'form_id', 'template_id'], 'required'],
            [['form_id', 'status', 'event', 'allow_partial_payment', 'allow_tip', 'tax_calculated_after_discount', 'tax_inclusive', 'amount_breakdown_invoice_discount_percent', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['conditions', 'note', 'term', 'memo', 'invoicer_additional_notes'], 'string'],
            [['name', 'mode', 'client_id', 'client_secret', 'sandbox_client_id', 'sandbox_client_secret', 'payment_term_type', 'payment_term_due_date', 'invoicer_given_name', 'invoicer_given_surname', 'invoicer_address_line_1', 'invoicer_address_line_2', 'invoicer_admin_area_2', 'invoicer_admin_area_1', 'invoicer_email_address', 'invoicer_phone_country_code', 'invoicer_phone_national_number', 'invoicer_phone_type', 'minimum_amount_due_value', 'template_id', 'amount_breakdown_custom_label', 'amount_breakdown_custom_amount_value', 'amount_breakdown_shipping_amount_value', 'amount_breakdown_shipping_tax_name', 'amount_breakdown_shipping_tax_percent'], 'string', 'max' => 255],
            [['oauth', 'sandbox_oauth', 'reference'], 'string', 'max' => 2550],
            [['currency_code', 'minimum_amount_due_currency_code', 'amount_breakdown_custom_amount_currency_code', 'amount_breakdown_shipping_amount_currency_code'], 'string', 'max' => 3],
            [['invoicer_postal_code'], 'string', 'max' => 10],
            [['invoicer_country_code'], 'string', 'max' => 5],
            [['invoicer_website', 'invoicer_tax_id', 'invoicer_logo_url'], 'string', 'max' => 2555],
            [['client_id', 'client_secret'], 'required', 'when' => function ($model) {
                return $model->mode == 'live';
            }, 'whenClient' => "function (attribute, value) {
                return $(\"#paypalinvoicing-mode\").val() === 'live';
            }"],
            [['sandbox_client_id', 'sandbox_client_secret'], 'required', 'when' => function ($model) {
                return $model->mode == 'live';
            }, 'whenClient' => "function (attribute, value) {
                return $(\"#paypalinvoicing-mode\").val() === 'sandbox';
            }"],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'status' => Yii::t('app', 'Status'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'event' => Yii::t('app', 'Event'),
            'mode' => Yii::t('app', 'Mode'),
            'client_id' => Yii::t('app', 'Client ID'),
            'client_secret' => Yii::t('app', 'Client Secret'),
            'oauth' => Yii::t('app', 'Oauth'),
            'sandbox_client_id' => Yii::t('app', 'Sandbox Client ID'),
            'sandbox_client_secret' => Yii::t('app', 'Sandbox Client Secret'),
            'sandbox_oauth' => Yii::t('app', 'Sandbox Oauth'),
            'reference' => Yii::t('app', 'Reference'),
            'currency_code' => Yii::t('app', 'Currency Code'),
            'note' => Yii::t('app', 'Note'),
            'term' => Yii::t('app', 'Term'),
            'memo' => Yii::t('app', 'Memo'),
            'payment_term_type' => Yii::t('app', 'Payment Term Type'),
            'payment_term_due_date' => Yii::t('app', 'Payment Term Due Date'),
            'invoicer_given_name' => Yii::t('app', 'Invoicer Given Name'),
            'invoicer_given_surname' => Yii::t('app', 'Invoicer Given Surname'),
            'invoicer_address_line_1' => Yii::t('app', 'Invoicer Address Line 1'),
            'invoicer_address_line_2' => Yii::t('app', 'Invoicer Address Line 2'),
            'invoicer_admin_area_2' => Yii::t('app', 'Invoicer Admin Area 2'),
            'invoicer_admin_area_1' => Yii::t('app', 'Invoicer Admin Area 1'),
            'invoicer_postal_code' => Yii::t('app', 'Invoicer Postal Code'),
            'invoicer_country_code' => Yii::t('app', 'Invoicer Country Code'),
            'invoicer_email_address' => Yii::t('app', 'Invoicer Email Address'),
            'invoicer_phone_country_code' => Yii::t('app', 'Invoicer Phone Country Code'),
            'invoicer_phone_national_number' => Yii::t('app', 'Invoicer Phone National Number'),
            'invoicer_phone_type' => Yii::t('app', 'Invoicer Phone Type'),
            'invoicer_website' => Yii::t('app', 'Invoicer Website'),
            'invoicer_tax_id' => Yii::t('app', 'Invoicer Tax ID'),
            'invoicer_logo_url' => Yii::t('app', 'Invoicer Logo Url'),
            'invoicer_additional_notes' => Yii::t('app', 'Invoicer Additional Notes'),
            'allow_partial_payment' => Yii::t('app', 'Allow Partial Payment'),
            'minimum_amount_due_currency_code' => Yii::t('app', 'Minimum Amount Due Currency Code'),
            'minimum_amount_due_value' => Yii::t('app', 'Minimum Amount Due Value'),
            'allow_tip' => Yii::t('app', 'Allow Tip'),
            'tax_calculated_after_discount' => Yii::t('app', 'Tax Calculated After Discount'),
            'tax_inclusive' => Yii::t('app', 'Tax Inclusive'),
            'template_id' => Yii::t('app', 'Template ID'),
            'amount_breakdown_custom_label' => Yii::t('app', 'Amount Breakdown Custom Label'),
            'amount_breakdown_custom_amount_currency_code' => Yii::t('app', 'Amount Breakdown Custom Amount Currency Code'),
            'amount_breakdown_custom_amount_value' => Yii::t('app', 'Amount Breakdown Custom Amount Value'),
            'amount_breakdown_shipping_amount_currency_code' => Yii::t('app', 'Amount Breakdown Shipping Amount Currency Code'),
            'amount_breakdown_shipping_amount_value' => Yii::t('app', 'Amount Breakdown Shipping Amount Value'),
            'amount_breakdown_shipping_tax_name' => Yii::t('app', 'Amount Breakdown Shipping Tax Name'),
            'amount_breakdown_shipping_tax_percent' => Yii::t('app', 'Amount Breakdown Shipping Tax Percent'),
            'amount_breakdown_invoice_discount_percent' => Yii::t('app', 'Amount Breakdown Invoice Discount Percent'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }


    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(PaypalInvoicingItem::class, ['paypal_invoicing_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getRecipients()
    {
        return $this->hasMany(PaypalInvoicingRecipient::class, ['paypal_invoicing_id' => 'id']);
    }

    public function setRecipients($value)
    {
        $this->loadRelated('recipients', $value);
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            PaypalInvoicingItem::deleteAll(['paypal_invoicing_id' => $this->id]);
            PaypalInvoicingRecipient::deleteAll(['paypal_invoicing_id' => $this->id]);
            PaypalInvoicingInvoice::deleteAll(['paypal_invoicing_id' => $this->id]);
            return true;
        } else {
            return false;
        }
    }

    /**
     * @param $item
     * @return bool
     */
    public function beforeRSave($item)
    {
        $isValid = true;
        if ($item instanceof PaypalInvoicingItem) {
            $isValid = !empty($item->name) && !empty($item->price);
        } elseif ($item instanceof PaypalInvoicingRecipient) {
            $isValid = !empty($item->billing_email_address);
        }
        return $isValid;
    }
}
