<?php

use yii\db\Migration;

/**
 * Class m200628_201529_update_to_1_2
 */
class m200628_201529_update_to_1_2 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Improve table structure
        $this->alterColumn('{{%addon_paypal_invoicing}}', 'oauth', $this->text());
        $this->alterColumn('{{%addon_paypal_invoicing}}', 'sandbox_oauth', $this->text());
        $this->alterColumn('{{%addon_paypal_invoicing}}', 'reference', $this->text());
        $this->alterColumn('{{%addon_paypal_invoicing}}', 'invoicer_website', $this->text());
        $this->alterColumn('{{%addon_paypal_invoicing}}', 'invoicer_tax_id', $this->text());
        $this->alterColumn('{{%addon_paypal_invoicing}}', 'invoicer_logo_url', $this->text());

        // Add Conditional logic fields
        $this->addColumn('{{%addon_paypal_invoicing}}', 'name', $this->text()->notNull()->after('status'));
        $this->addColumn('{{%addon_paypal_invoicing}}', 'event', $this->integer(3)->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_paypal_invoicing}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_paypal_invoicing_item}}', 'paypal_invoicing_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_paypal_invoicing_item}}', 'paypal_invoicing_id');

        $this->dropColumn('{{%addon_paypal_invoicing}}', 'event');
        $this->dropColumn('{{%addon_paypal_invoicing}}', 'conditions');
        $this->dropColumn('{{%addon_paypal_invoicing}}', 'name');
    }

}
