<?php

use yii\db\Migration;

/**
 * Class m190626_174635_init_addon_paypal_invoicing
 */
class m190626_174635_init_addon_paypal_invoicing extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_paypal_invoicing}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->text(),

            // Authorization
            'mode' => $this->string(191)->notNull()->defaultValue('sandbox'), // 'sandbox' or 'live'
            // Live
            'client_id' => $this->text(),
            'client_secret' => $this->text(),
            'oauth' => $this->text(),
            // Sandbox
            'sandbox_client_id' => $this->text(),
            'sandbox_client_secret' => $this->text(),
            'sandbox_oauth' => $this->text(),
            // Template
            'template_id' => $this->text(),
            // Detail
            'reference' => $this->text(),
            'currency_code' => $this->string(3)->defaultValue('USD'),
            'note' => $this->text(),
            'term' => $this->text(),
            'memo' => $this->text(),
            'payment_term_type' => $this->text(),
            'payment_term_due_date' => $this->text(),
            // Invoicer
            // - Name
            'invoicer_given_name' => $this->text(),
            'invoicer_given_surname' => $this->text(),
            // - Address
            'invoicer_address_line_1' => $this->text(),
            'invoicer_address_line_2' => $this->text(),
            'invoicer_admin_area_2' => $this->text(),
            'invoicer_admin_area_1' => $this->text(),
            'invoicer_postal_code' => $this->string(10),
            'invoicer_country_code' => $this->string(5),
            // - Email Address
            'invoicer_email_address' => $this->text(),
            // - Phone
            'invoicer_phone_country_code' => $this->text(),
            'invoicer_phone_national_number' => $this->text(),
            'invoicer_phone_type' => $this->text(),
            // - Other
            'invoicer_website' => $this->text(),
            'invoicer_tax_id' => $this->text(),
            'invoicer_logo_url' => $this->text(),
            'invoicer_additional_notes' => $this->text(),
            // Payment Configuration
            'allow_partial_payment' => $this->boolean(),
            'minimum_amount_due_currency_code' => $this->string(3),
            'minimum_amount_due_value' => $this->text(),
            'allow_tip' => $this->boolean(),
            'tax_calculated_after_discount' => $this->boolean(),
            'tax_inclusive' => $this->boolean(),
            // Amount breakdown
            'amount_breakdown_custom_label' => $this->text(),
            'amount_breakdown_custom_amount_currency_code' => $this->string(3)->defaultValue('USD'),
            'amount_breakdown_custom_amount_value' => $this->text(),
            'amount_breakdown_shipping_amount_currency_code' => $this->string(3)->defaultValue('USD'),
            'amount_breakdown_shipping_amount_value' => $this->text(),
            'amount_breakdown_shipping_tax_name' => $this->text(),
            'amount_breakdown_shipping_tax_percent' => $this->text(),
            'amount_breakdown_invoice_discount_percent' => $this->integer(255),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),

        ], $tableOptions);

        $this->createTable('{{%addon_paypal_invoicing_recipient}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            // Billing info
            // - Email Address
            'billing_email_address' => $this->text()->notNull(),
            // - Language
            'billing_language' => $this->text()->notNull(),
            // - Name
            'billing_name' => $this->text(),
            'billing_surname' => $this->text(),
            // - Address
            'billing_address_line_1' => $this->text(),
            'billing_admin_area_2' => $this->text(),
            'billing_admin_area_1' => $this->text(),
            'billing_postal_code' => $this->string(10),
            'billing_country_code' => $this->string(5),
            // - Phone
            'billing_phone_country_code' => $this->text(),
            'billing_phone_national_number' => $this->text(),
            'billing_phone_type' => $this->text(),
            // - Other
            'billing_additional_value' => $this->text(),
            // Shipping info
            // - Name
            'shipping_name' => $this->text(),
            'shipping_surname' => $this->text(),
            // - Address
            'shipping_address_line_1' => $this->text(),
            'shipping_admin_area_2' => $this->text(),
            'shipping_admin_area_1' => $this->text(),
            'shipping_postal_code' => $this->string(10),
            'shipping_country_code' => $this->string(5),
        ], $tableOptions);

        $this->createTable('{{%addon_paypal_invoicing_item}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            // Item
            'name' => $this->string(200)->notNull(),
            'description' => $this->text(),
            'quantity' => $this->text()->notNull(),
            'price' => $this->text()->notNull(),
            'tax_name' => $this->text(),
            'tax_percent' => $this->text(),
            'discount_percent' => $this->text(),
        ], $tableOptions);

        $this->createTable('{{%addon_paypal_invoicing_invoice}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'paypal_invoicing_id' => $this->integer(11),
            'submission_id' => $this->integer(11),

            'data' => $this->text()->notNull(), // Save response as JSON
            'success' => $this->boolean()->notNull(),
            'status' => $this->string(191)->notNull()->defaultValue('DRAFT'),

            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_paypal_invoicing_invoice}}');
        $this->dropTable('{{%addon_paypal_invoicing_item}}');
        $this->dropTable('{{%addon_paypal_invoicing_recipient}}');
        $this->dropTable('{{%addon_paypal_invoicing}}');
    }
}
