<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.1
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

namespace app\modules\addons\modules\paypal_invoicing\controllers;

use yii\web\Response;
use yii\web\Controller;
use app\modules\addons\modules\paypal_invoicing\models\PaypalInvoicing;
use app\modules\addons\modules\paypal_invoicing\models\PaypalInvoicingPayment;
use app\modules\addons\modules\paypal_invoicing\helpers\PayPalService;

/**
 * CheckController implements the CRUD actions for PaypalInvoicing model.
 */
class CheckController extends Controller
{

    /**
     * Execute PayPal Payment
     *
     * @param int $id PaypalInvoicing Model ID
     * @param int $form_id Form Model ID
     * @param int $submission_id Submission Model ID
     * @return Response
     */
    public function actionPayment($id, $form_id, $submission_id)
    {
        $model = PaypalInvoicing::findOne(['id' => $id]);

        if ($model !== null && isset($_GET['paymentId'], $_GET['PayerID'])) {

            // Execute payment
            $payPalService = new PayPalService(
                $model->client_id, $model->client_secret, $model->mode
            );
            $payment = $payPalService->executePayment($_GET['paymentId'], $_GET['PayerID']);

            // Store Payment Details on the Database
            $p = json_decode($payment->toJSON());
            if (isset($p->id, $p->payer, $p->transactions)) {
                $paymentModel = new PaypalInvoicingPayment();
                $paymentModel->form_id = $form_id;
                $paymentModel->paypal_invoicing_id = $model->id;
                $paymentModel->submission_id = $submission_id;
                $paymentModel->payment_id = $p->id;
                $paymentModel->payment_state = $p->state;
                $paymentModel->payment_method = $p->payer->payment_method;
                $paymentModel->payer_status = $p->payer->status;
                $paymentModel->payer_email = $p->payer->payer_info->email;
                $paymentModel->payer_first_name = $p->payer->payer_info->first_name;
                $paymentModel->payer_last_name = $p->payer->payer_info->last_name;
                $paymentModel->payer_id = $p->payer->payer_info->payer_id;
                $paymentModel->payer_country_code = $p->payer->payer_info->country_code;
                foreach ($p->transactions as $transaction) {
                    $paymentModel->transaction_total = $transaction->amount->total;
                    $paymentModel->transaction_currency = $transaction->amount->currency;
                    $paymentModel->transaction_merchant_id = $transaction->payee->merchant_id;
                    $paymentModel->payee_email = $transaction->payee->email;
                }
                $paymentModel->save(false);
            }

            // Redirect to another page
            return $this->redirect($model->return_url . (strpos($model->return_url, '?') === false ? '?' : '&') . http_build_query(['success' => is_object($payment)]));
        }
    }
}