<?php

use yii\web\View;
use yii\helpers\Url;
use yii\helpers\Html;
use app\components\widgets\ActionBar;
use app\components\widgets\GridView;
use app\components\widgets\PageSizeDropDownList;
use kartik\switchinput\SwitchInput;

/* @var $this yii\web\View */
/* @var $searchModel app\modules\addons\modules\paypal\models\PaypalSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */
/* @var $model app\modules\addons\modules\paypal\models\Paypal */

$this->title = Yii::t('app', 'PayPal Payments');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Paypal'), 'url' => ['index']];
$this->params['breadcrumbs'][] = Yii::t('app', 'Payments');

// User Preferences
$showFilters = Yii::$app->user->preferences->get('GridView.filters.state') === '1';

$options = array(
    'currentPage' => Url::toRoute(['payments']), // Used by filters
    'gridViewSettingsEndPoint' => Url::to(['/ajax/grid-view-settings']),
);

// Pass php options to javascript
$this->registerJs("var options = ".json_encode($options).";", View::POS_BEGIN, 'form-options');

$gridColumns = [
    [
        'class' => '\kartik\grid\SerialColumn'
    ],
    [
        'attribute'=> 'submission',
        'label' => Yii::t('app', 'Submission'),
        'format' => 'raw',
        'value' => function ($model) {
            return isset($model->form_id, $model->submission_id) ?
                Html::a('#' . $model->submission_id, ['/form/submissions', 'id' => $model->form_id, '#' => 'view/'.$model->submission_id ]) :
                null;
        },
    ],
    'payer_email',
    'payee_email',
    'transaction_currency',
    'transaction_total',
    'payment_id',
    [
        'attribute'=> 'paid',
        'value' => function ($model) {
            return $model->created;
        },
        'label' => Yii::t('app', 'Date'),
        'noWrap'=>true,
        'filterType'=> \kartik\grid\GridView::FILTER_DATE_RANGE,
        'filterWidgetOptions' => [
            'presetDropdown' => false,
            'convertFormat' => true,
            'containerTemplate' => '
        <div class="form-control kv-drp-dropdown">
            <i class="glyphicon glyphicon-calendar"></i>&nbsp;
            <span class="range-value">{value}</span>
            <span><b class="caret"></b></span>
        </div>
        {input}
',
            'pluginOptions' => [
                'showDropdowns' => true,
                'linkedCalendars' => false,
                'locale' => [
                    'dateFormat' => 'Y-m-d',
                    'separator' => ' - ',
                ],
                'opens' => 'left'
            ]
        ],
    ],
];

$options = array(
    'currentPage' => Url::toRoute(['payments', 'id' => $model->id]), // Used by filters
);

// Pass php options to javascript
$this->registerJs("var options = ".json_encode($options).";", View::POS_BEGIN, 'form-options');

?>
<div class="paypal-index">

    <div class="row">
        <div class="col-md-12">
            <?= GridView::widget([
                'id' => 'paypal-grid',
                'dataProvider' => $dataProvider,
                'filterModel' => $searchModel,
                'columns' => $gridColumns,
                'resizableColumns' => false,
                'pjax' => false,
                'export' => false,
                'responsive' => true,
                'bordered' => false,
                'striped' => true,
                'panelTemplate' => Html::tag('div', '{panelHeading}{panelBefore}{items}{panelFooter}', ['class' => 'panel {type}']),
                'panel' => [
                    'type' => GridView::TYPE_INFO,
                    'heading'=> $model->form->name . ' <small class="panel-subtitle hidden-xs">'. Yii::t('app', 'PayPal Payments').'</small>',
                    // Visible only for admin user
                    'before'=> (!empty(Yii::$app->user) && Yii::$app->user->can("admin")) ?
                        ActionBar::widget([
                            'grid' => 'paypal-grid',
                            'templates' => [
                                '{back}' => ['class' => 'col-xs-6 col-md-8'],
                                '{filters}' => ['class' => 'col-xs-6 col-md-4'],
                            ],
                            'elements' => [
                                'back' =>
                                    Html::a(
                                        '<span class="glyphicon glyphicon-arrow-left"></span> ' .
                                        Yii::t('app', 'Go Back'),
                                        ['index'],
                                        ['class' => 'btn btn-default']
                                    ),
                                'filters' => SwitchInput::widget(
                                    [
                                        'name'=>'filters',
                                        'type' => SwitchInput::CHECKBOX,
                                        'pluginOptions' => [
                                            'size' => 'mini',
                                            'animate' => false,
                                            'labelText' => Yii::t('app', 'Filter'),
                                        ],
                                        'pluginEvents' => [
                                            "switchChange.bootstrapSwitch" => "function(event, state) {
                                                if (state) {
                                                    $('.filters').fadeIn()
                                                    localStorage.setItem('gridView.filters', 1);
                                                } else {
                                                    $('.filters').fadeOut()
                                                    localStorage.setItem('gridView.filters', 0);
                                                    window.location = options.currentPage;
                                                }
                                            }",
                                        ],
                                        'containerOptions' => ['style' => 'margin-top: 6px; text-align: right'],
                                    ]
                                ),
                            ],
                        ]) : null,
                ],
                'replaceTags' => [
                    '{pageSize}' => function($widget) {
                        $html = '';
                        if ($widget->panelFooterTemplate !== false) {
                            $selectedSize = Yii::$app->user->preferences->get('GridView.pagination.pageSize');
                            return PageSizeDropDownList::widget(['selectedSize' => $selectedSize]);
                        }
                        return $html;
                    },
                ],
                'panelFooterTemplate' => '
                    <div class="kv-panel-pager">
                        {pageSize}
                        {pager}
                    </div>
                ',
                'toolbar' => false
            ]); ?>
        </div>
    </div>
</div>
