<?php

use app\components\widgets\ConditionsBuilder;
use yii\helpers\Html;
use yii\helpers\Url;
use kartik\form\ActiveForm;
use kartik\select2\Select2;
use kartik\switchinput\SwitchInput;
use kartik\depdrop\DepDrop;

/* @var $this yii\web\View */
/* @var $form kartik\form\ActiveForm */
/* @var $model app\modules\addons\modules\paypal\models\Paypal */
/* @var $itemModel app\modules\addons\modules\paypal\models\PaypalItem */
/* @var $forms array [id => name] of Form models */

$this->title = Yii::t('app', 'Set Up a Payment Form');
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Add-ons'), 'url' => ['/addons']];
$this->params['breadcrumbs'][] = ['label' => Yii::t('app', 'Paypal'), 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

$url = Url::to(['/addons/paypal/admin/fields']);
$currencyUrl = Url::to(['/addons/paypal/admin/currency-fields']);
?>
<!-- Page header -->
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row g-2 align-items-center">
            <div class="col">
                <?= $this->render('@app/themes/next/views/partials/_breadcrumbs') ?>
            </div>
        </div>
    </div>
</div>
<div class="page-header d-print-none">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <h2 class="page-title">
                    <?= Html::encode($this->title) ?>
                </h2>
            </div>
        </div>
    </div>
</div>
<!-- Page body -->
<div class="page-body">
    <div class="container-xl">
        <div class="row">
            <div class="col">
                <div class="card">
                    <div class="card-header">
                        <div class="card-title">
                            <?= Html::encode($this->title) ?>
                        </div>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(); ?>

                        <div class="row" style="margin-top: 20px;">
                            <div class="col-sm-12">
                                <?= $form->field($model, 'name')->textInput([
                                    'placeholder' => Yii::t('app', "Enter a configuration name..."),
                                    'maxlength' => true,
                                ]) ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <?= $form->field($model, 'form_id')->widget(Select2::class, [
                                    'data' => $forms,
                                    'options' => ['placeholder' => Yii::t('app', 'Select a form...')],
                                    'pluginOptions' => [
                                        'allowClear' => true
                                    ],
                                ])->label(Yii::t('app', 'Form')); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-3">
                                <?= $form->field($model, 'client_id')->textInput([
                                    'maxlength' => true,
                                ]) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'client_secret')->textInput([
                                    'maxlength' => true,
                                ]) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'return_url')->textInput([
                                    'maxlength' => true,
                                ]) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'cancel_url')->textInput([
                                    'maxlength' => true,
                                ]) ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <?= $form->field($model, 'message')->textInput([
                                    'maxlength' => true,
                                    'placeholder' => Yii::t('app', 'You are now being redirected to PayPal...'),
                                    'value' => Yii::t('app', 'You are now being redirected to PayPal...'),
                                ]) ?>
                            </div>
                            <div class="col-sm-2">
                                <?= $form->field($model, 'mode')->dropDownList(
                                    ['sandbox' => 'Sandbox', 'live' => 'Live']
                                ) ?>
                            </div>
                        </div>
                        <div class="row" style="margin-bottom: 10px">
                            <div class="col-sm-12">
                <span class="help-block">
                <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                    <?= Yii::t(
                        'app',
                        'Sandbox Mode allows you to test your Form without submitting live transactions.'
                    ) ?>
                    <?= Html::a(Yii::t('app', 'Get your PayPal API keys'), 'https://developer.paypal.com') ?>.
                </span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <?= $form->field($model, 'event')->widget(Select2::class, [
                                    'data' => \app\helpers\EventHelper::supportedFormEventsInPostRequest(),
                                ]); ?>
                            </div>
                            <div class="col-sm-6">
                                <?php if ($model->isNewRecord) { $model->status = 1;} ?>
                                <?= $form->field($model, 'status')->widget(SwitchInput::class) ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <?= ConditionsBuilder::widget([
                                    'label' => Yii::t('app', 'Conditions'),
                                ]) ?>
                                <?= $form->field($model, "conditions", ['options' => ['class' => 'd-none']])->hiddenInput() ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <legend><?= Yii::t('app', 'Items') ?></legend>
                            </div>
                        </div>

                        <fieldset class="item">
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($itemModel, '[0]description')->textInput([
                                        'maxlength' => true,
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, '[0]price')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['paypal-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => Url::to(['/addons/paypal/admin/fields']),
                                            'params'=>['paypal-item_1']
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-2">
                                    <?= $form->field($itemModel, '[0]quantity')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['paypal-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => Url::to(['/addons/paypal/admin/fields']),
                                        ]
                                    ]) ?>
                                </div>
                                <div class="col-sm-1">
                                    <div class="form-group" style="padding-top: 28px;">
                                        <button type="button" class="btn btn-icon btn-default btn-add">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset id="itemTemplate" class="d-none">
                            <div class="row">
                                <div class="col-sm-6">
                                    <?= $form->field($itemModel, 'description')->textInput([
                                        'maxlength' => true,
                                        'disabled' => true,
                                    ]) ?>
                                </div>
                                <div class="col-sm-3">
                                    <?= $form->field($itemModel, 'price')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['paypal-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => Url::to(['/addons/paypal/admin/fields']),
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-2">
                                    <?= $form->field($itemModel, 'quantity')->widget(DepDrop::class, [
                                        'pluginOptions' => [
                                            'depends' => ['paypal-form_id'],
                                            'placeholder' => Yii::t('app', 'Select...'),
                                            'url' => Url::to(['/addons/paypal/admin/fields']),
                                        ],
                                        'pluginEvents' => [
                                            "depdrop:afterChange" => "function(event, id, value) { 
                                $(event.currentTarget).attr('disabled', true)
                            }",
                                        ],
                                    ]) ?>
                                </div>
                                <div class="col-sm-1">
                                    <div class="form-group" style="padding-top: 28px;">
                                        <button type="button" class="btn btn-icon btn-default btn-remove">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <div class="row">
                            <div class="col-sm-12">
                <span class="help-block">
                    <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                    <?= Yii::t(
                        'app',
                        'Each item specify information about a product or service.'
                    ) ?>
                    <?= Yii::t(
                        'app',
                        'Quantity (optional) and Tax (optional) will be multiplied by Price in order to get the item total value.'
                    ) ?>
                </span>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <legend><?= Yii::t('app', 'Transaction Settings') ?></legend>
                            </div>
                            <div class="col-sm-3">
                                <?= Html::hiddenInput('currency', $model->currency, ['id'=>'currency']) ?>
                                <?= $form->field($model, 'currency')->widget(DepDrop::class, [
                                    'type' => DepDrop::TYPE_SELECT2,
                                    'pluginOptions' => [
                                        'depends' => ['paypal-form_id'],
                                        'placeholder' => Yii::t('app', 'Select...'),
                                        'url' => $currencyUrl,
                                        'initialize' => !$model->isNewRecord,
                                        'params'=>['currency'],
                                    ]
                                ])->hint(Yii::t('app', 'The currency in which the charge will be made.')) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'shipping')->widget(DepDrop::class, [
                                    'pluginOptions' => [
                                        'depends' => ['paypal-form_id'],
                                        'placeholder' => Yii::t('app', 'Select...'),
                                        'url' => Url::to(['/addons/paypal/admin/fields']),
                                    ],
                                ]) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'handling')->widget(DepDrop::class, [
                                    'pluginOptions' => [
                                        'depends' => ['paypal-form_id'],
                                        'placeholder' => Yii::t('app', 'Select...'),
                                        'url' => Url::to(['/addons/paypal/admin/fields']),
                                    ],
                                ]) ?>
                            </div>
                            <div class="col-sm-3">
                                <?= $form->field($model, 'tax')->widget(DepDrop::class, [
                                    'pluginOptions' => [
                                        'depends' => ['paypal-form_id'],
                                        'placeholder' => Yii::t('app', 'Select...'),
                                        'url' => Url::to(['/addons/paypal/admin/fields']),
                                    ],
                                ]) ?>
                            </div>
                            <div class="col-sm-12">
                                <?= $form->field($model, 'payment_description')->textarea(['rows' => '3']) ?>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                <span class="help-block">
                    <span class="label label-default"><?= Yii::t('app', 'Note') ?></span>
                    <?= Yii::t(
                        'app',
                        'Shipping, Handling and Tax are added to the items total value.'
                    ) ?>
                </span>
                            </div>
                        </div>

                        <div class="form-group">
                            <?= Html::submitButton($model->isNewRecord ?
                                Yii::t('app', 'Save') :
                                Yii::t('app', 'Update'), ['class' => 'btn btn-primary']) ?>
                        </div>

                        <?php ActiveForm::end(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php

$this->registerCss("legend { margin-top: 20px; }");

/**
 * Conditional Logic
 */

$ruleBuilderURL = Url::to(['/form/rule-builder']);
$initialize = (int)!$model->isNewRecord;

$script = <<<JS

$(document).ready(function(){

    // Load Conditions Widget
    $("body")
        .find('.rule-builder-conditions')
        .attr('id', 'conditions-builder-1')
        .conditionsWidget({
            'field': '#paypal-conditions',
            'url': '{$ruleBuilderURL}',
            'depends': ['paypal-form_id'],
            'initialize': parseInt("{$initialize}")
        })
        .end()

});

JS;

$this->registerJs($script, $this::POS_END, 'paypal-conditions');

/**
 * Field Mapping
 */

$script = <<<JS

$(document).ready(function(){

    var item = 0;

    $('form')
        // Add button click handler
        .on('click', '.btn-add', function() {

            var template = $('#itemTemplate'),
                cloned = template
                    .clone()
                    .removeClass('d-none')
                    .addClass('item')
                    .removeAttr('id')
                    .insertBefore(template);
            item++;

            // Update the name attributes
            cloned
                .find('[name="PaypalItem[description]"]')
                    .attr('name', 'PaypalItem[' + item + '][description]')
                    .attr('id', 'paypalitem-' + item + '-description')
                    .removeAttr('disabled')
                    .end()
                .find('[name="PaypalItem[price]"]')
                    .attr('name', 'PaypalItem[' + item + '][price]')
                    .attr('id', 'paypalitem-' + item + '-price')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypal-form_id'],
                        url: '$url'
                    })
                    .end()
                .find('[name="PaypalItem[quantity]"]')
                    .attr('name', 'PaypalItem[' + item + '][quantity]')
                    .attr('id', 'paypalitem-' + item + '-quantity')
                    .removeAttr('disabled')
                    .depdrop({
                        depends: ['paypal-form_id'],
                        url: '$url'
                    })
                    .end()
        })
        // Remove button click handler
        .on('click', '.btn-remove', function() {
            var fieldset = $(this).closest('fieldset');
            fieldset.remove();
        });

})

JS;
$this->registerJs($script, $this::POS_END);
?>
