<?php

namespace app\modules\addons\modules\paypal\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;

/**
 * PaypalPaymentSearch represents the model behind the search form about `app\modules\addons\modules\paypal\models\PaypalPayment`.
 */
class PaypalPaymentSearch extends PaypalPayment
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'form_id', 'paypal_id', 'submission_id', 'created_at', 'updated_at'], 'integer'],
            [['payment_id', 'payment_state', 'payment_method', 'payer_status', 'payer_email', 'payer_first_name', 'payer_last_name', 'payer_id', 'payer_country_code', 'transaction_total', 'transaction_currency', 'transaction_merchant_id', 'payee_email'], 'safe'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = PaypalPayment::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'pageSize' => Yii::$app->user->preferences->get('GridView.pagination.pageSize'),
            ],
            'sort' => [
                'defaultOrder' => [
                    'updated_at' => SORT_DESC,
                ]
            ],
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // Add Scope
        if (isset($params['id'])) {
            $this->paypal_id = $params['id'];
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'form_id' => $this->form_id,
            'submission_id' => $this->submission_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

        $query->andFilterWhere(['like', 'payment_id', $this->payment_id])
            ->andFilterWhere(['like', 'payment_state', $this->payment_state])
            ->andFilterWhere(['like', 'payment_method', $this->payment_method])
            ->andFilterWhere(['like', 'payer_status', $this->payer_status])
            ->andFilterWhere(['like', 'payer_email', $this->payer_email])
            ->andFilterWhere(['like', 'payer_first_name', $this->payer_first_name])
            ->andFilterWhere(['like', 'payer_last_name', $this->payer_last_name])
            ->andFilterWhere(['like', 'payer_id', $this->payer_id])
            ->andFilterWhere(['like', 'payer_country_code', $this->payer_country_code])
            ->andFilterWhere(['like', 'transaction_total', $this->transaction_total])
            ->andFilterWhere(['like', 'transaction_currency', $this->transaction_currency])
            ->andFilterWhere(['like', 'transaction_merchant_id', $this->transaction_merchant_id])
            ->andFilterWhere(['like', 'payee_email', $this->payee_email]);

        return $dataProvider;
    }
}