<?php

namespace app\modules\addons\modules\paypal\models;

use app\components\behaviors\DateTrait;
use app\models\Form;
use app\models\FormSubmission;
use Yii;
use yii\behaviors\TimestampBehavior;
use yii\helpers\Url;

/**
 * This is the model class for table "{{%addon_paypal_payment}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $paypal_id
 * @property integer $submission_id
 * @property string $payment_id
 * @property string $payment_state
 * @property string $payment_method
 * @property string $payer_status
 * @property string $payer_email
 * @property string $payer_first_name
 * @property string $payer_last_name
 * @property string $payer_id
 * @property string $payer_country_code
 * @property string $transaction_total
 * @property string $transaction_currency
 * @property string $transaction_merchant_id
 * @property string $payee_email
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Paypal $paypal
 * @property Form $form
 * @property FormSubmission $submission
 */
class PaypalPayment extends \yii\db\ActiveRecord
{
    use DateTrait;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_paypal_payment}}';
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'paypal_id', 'submission_id'], 'integer'],
            [['payment_id', 'payment_state', 'payment_method', 'payer_status', 'payer_email', 'payer_first_name', 'payer_last_name', 'payer_id', 'payer_country_code', 'transaction_total', 'transaction_currency', 'transaction_merchant_id', 'payee_email'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'paypal_id' => Yii::t('app', 'PayPal ID'),
            'submission_id' => Yii::t('app', 'Submission ID'),
            'payment_id' => Yii::t('app', 'Payment ID'),
            'payment_state' => Yii::t('app', 'Payment State'),
            'payment_method' => Yii::t('app', 'Payment Method'),
            'payer_status' => Yii::t('app', 'Payer Status'),
            'payer_email' => Yii::t('app', 'Payer Email'),
            'payer_first_name' => Yii::t('app', 'Payer First Name'),
            'payer_last_name' => Yii::t('app', 'Payer Last Name'),
            'payer_id' => Yii::t('app', 'Payer ID'),
            'payer_country_code' => Yii::t('app', 'Payer Country Code'),
            'transaction_total' => Yii::t('app', 'Amount'),
            'transaction_currency' => Yii::t('app', 'Currency'),
            'transaction_merchant_id' => Yii::t('app', 'Transaction Merchant ID'),
            'payee_email' => Yii::t('app', 'Payee Email'),
            'payment_link' => Yii::t('app', 'Payment Link'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @inheritdoc
     */
    public function fields()
    {
        return ['id', 'paypal_id', 'payment_id', 'payment_state', 'payment_method', 'payer_status', 'payer_email',
            'payer_first_name', 'payer_last_name', 'payer_id', 'payer_country_code', 'transaction_total',
            'transaction_currency', 'transaction_merchant_id', 'payee_email', 'created_at', 'payment_link'];
    }

    /**
     * Get Labels For Field Mapping
     *
     * @return array
     */
    public function getLabelsForFieldMapping()
    {
        $fields = $this->fields();
        $attributes = $this->attributeLabels();
        $labels = [];
        foreach ($fields as $field) {
            $labels['paypal_' . $field] = "PayPal - " . $attributes[$field];
        }
        return $labels;
    }

    /**
     * Get Values For Field Mapping
     *
     * @param $fields
     * @return array
     */
    public function getValuesForFieldMapping($fields)
    {
        $attributes = $this->toArray($fields);
        $values = [];
        foreach ($attributes as $key => $value) {
            $values['paypal_' . $key] = $value;
        }
        return $values;
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaypal()
    {
        return $this->hasOne(Paypal::class,['id' => 'paypal_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getSubmission()
    {
        return $this->hasOne(FormSubmission::class, ['id' => 'submission_id']);
    }

    /**
     * Get Payment Link
     * Note: We can use this link, when a form is submitted without a complete payment in the gateway payment
     *
     * @return string
     */
    public function getPayment_Link()
    {
        return Url::to(['/addons/paypal/check/approval', 'sid' => $this->submission->hashId], true);
    }
}