<?php

namespace app\modules\addons\modules\paypal\models;

use Yii;

/**
 * This is the model class for table "{{%addon_paypal_item}}".
 *
 * @property integer $id
 * @property integer $paypal_id
 * @property integer $form_id
 * @property string $quantity
 * @property string $name
 * @property string $price
 * @property string $currency
 * @property string $sku
 * @property string $description
 * @property string $tax
 */
class PaypalItem extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_paypal_item}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['paypal_id', 'form_id'], 'integer'],
            [['currency'], 'string', 'max' => 3],
            [['tax'], 'string', 'max' => 10],
            [['sku'], 'string', 'max' => 50],
            [['name', 'description'], 'string', 'max' => 127],
            [['quantity', 'price'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'paypal_id' => Yii::t('app', 'Paypal ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'quantity' => Yii::t('app', 'Quantity'),
            'name' => Yii::t('app', 'Name'),
            'price' => Yii::t('app', 'Price'),
            'currency' => Yii::t('app', 'Currency'),
            'sku' => Yii::t('app', 'Sku'),
            'description' => Yii::t('app', 'Description'),
            'tax' => Yii::t('app', 'Tax'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getPaypal()
    {
        return $this->hasOne(Paypal::class,['id'=>'paypal_id']);
    }
}
