<?php

namespace app\modules\addons\modules\paypal\models;

use app\components\behaviors\DateTrait;
use app\models\User;
use Yii;
use app\models\Form;
use app\components\behaviors\RelationTrait;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_paypal}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property string $client_id
 * @property string $client_secret
 * @property string $return_url
 * @property string $cancel_url
 * @property string $mode
 * @property integer $status
 * @property string $name
 * @property string $conditions
 * @property integer $event
 * @property string $message
 * @property string $intent
 * @property string $payment_method
 * @property string $payment_description
 * @property string $credit_card_number
 * @property string $credit_card_type
 * @property integer $credit_card_expire_month
 * @property integer $credit_card_expire_year
 * @property string $credit_card_cvv2
 * @property string $credit_card_first_name
 * @property string $credit_card_last_name
 * @property string $shipping
 * @property string $handling
 * @property string $tax
 * @property string $currency
 * @property string $address_line1
 * @property string $address_line2
 * @property string $address_city
 * @property string $address_country_code
 * @property string $address_postal_code
 * @property string $address_state
 * @property string $address_phone
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Form $form
 * @property PaypalItem[] $items
 * @property User $author
 * @property User $lastEditor
 */
class Paypal extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_paypal}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['name', 'form_id', 'client_id', 'client_secret', 'return_url', 'cancel_url'], 'required'],
            [['form_id', 'status', 'event'], 'integer'],
            [['conditions', 'payment_description'], 'string'],
            [['name', 'client_id', 'client_secret', 'return_url', 'cancel_url', 'mode', 'message', 'intent', 'payment_method', 'credit_card_number', 'credit_card_type', 'credit_card_expire_month', 'credit_card_expire_year', 'credit_card_cvv2', 'credit_card_first_name', 'credit_card_last_name', 'shipping', 'handling', 'tax', 'address_line1', 'address_line2', 'address_city', 'address_country_code', 'address_postal_code', 'address_state', 'address_phone'], 'string', 'max' => 255],
            [['currency'], 'string', 'max' => 45],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'client_id' => Yii::t('app', 'Client ID'),
            'client_secret' => Yii::t('app', 'Client Secret'),
            'return_url' => Yii::t('app', 'Return Url'),
            'cancel_url' => Yii::t('app', 'Cancel Url'),
            'mode' => Yii::t('app', 'Mode'),
            'status' => Yii::t('app', 'Status'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'event' => Yii::t('app', 'Event'),
            'message' => Yii::t('app', 'Message'),
            'intent' => Yii::t('app', 'Intent'),
            'payment_method' => Yii::t('app', 'Payment Method'),
            'payment_description' => Yii::t('app', 'Payment Description'),
            'credit_card_number' => Yii::t('app', 'Credit Card Number'),
            'credit_card_type' => Yii::t('app', 'Credit Card Type'),
            'credit_card_expire_month' => Yii::t('app', 'Credit Card Expire Month'),
            'credit_card_expire_year' => Yii::t('app', 'Credit Card Expire Year'),
            'credit_card_cvv2' => Yii::t('app', 'Credit Card Cvv2'),
            'credit_card_first_name' => Yii::t('app', 'Credit Card First Name'),
            'credit_card_last_name' => Yii::t('app', 'Credit Card Last Name'),
            'shipping' => Yii::t('app', 'Shipping'),
            'handling' => Yii::t('app', 'Handling'),
            'tax' => Yii::t('app', 'Tax'),
            'currency' => Yii::t('app', 'Currency'),
            'address_line1' => Yii::t('app', 'Address Line1'),
            'address_line2' => Yii::t('app', 'Address Line2'),
            'address_city' => Yii::t('app', 'Address City'),
            'address_country_code' => Yii::t('app', 'Address Country Code'),
            'address_postal_code' => Yii::t('app', 'Address Postal Code'),
            'address_state' => Yii::t('app', 'Address State'),
            'address_phone' => Yii::t('app', 'Address Phone'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(PaypalItem::class, ['paypal_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            PaypalItem::deleteAll(["paypal_id" => $this->id]);
            PaypalPayment::deleteAll(["paypal_id" => $this->id]);
            return true;
        } else {
            return false;
        }
    }

    /**
     * @param $item
     * @return bool
     */
    public function beforeRSave($item)
    {
        $isValid = true;
        if ($item instanceof PaypalItem) {
            $isValid = !empty($item->price);
        }
        return $isValid;
    }

}
