<?php

use yii\db\Migration;

/**
 * Class m200628_192604_update_to_1_5
 */
class m200628_192604_update_to_1_5 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_paypal}}', 'name', $this->text()->notNull()->after('status'));
        $this->addColumn('{{%addon_paypal}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_paypal}}', 'conditions', $this->text()->after('event'));

        // Currency field
        $this->alterColumn('{{%addon_paypal}}', 'currency', $this->string(45));

        // Add foreign column to fields
        $this->addColumn('{{%addon_paypal_item}}', 'paypal_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_paypal_item}}', 'paypal_id');

        $this->alterColumn('{{%addon_paypal}}', 'currency', $this->string(3));

        $this->dropColumn('{{%addon_paypal}}', 'event');
        $this->dropColumn('{{%addon_paypal}}', 'conditions');
        $this->dropColumn('{{%addon_paypal}}', 'name');
    }

}
