<?php

use yii\db\Migration;

class m161007_043028_upgrade_to_11 extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_paypal_payment}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'paypal_id' => $this->integer(11),
            'submission_id' => $this->integer(11),

            'payment_id' => $this->text(),
            'payment_state' => $this->text(),
            'payment_method' => $this->text(),
            'payer_status' => $this->text(),
            'payer_email' => $this->text(),
            'payer_first_name' => $this->text(),
            'payer_last_name' => $this->text(),
            'payer_id' => $this->text(),
            'payer_country_code' => $this->text(),
            'transaction_total' => $this->text(),
            'transaction_currency' => $this->text(),
            'transaction_merchant_id' => $this->text(),
            'payee_email' => $this->text(),

            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_paypal_payment}}');
    }
}
