<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

use yii\db\Migration;

class m160118_012839_init_addon_paypal extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_paypal}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'client_id' => $this->text()->notNull(),
            'client_secret' => $this->text()->notNull(),
            'return_url' => $this->text()->notNull(),
            'cancel_url' => $this->text()->notNull(),
            'mode' => $this->string(191)->notNull()->defaultValue('sandbox'), // 'sandbox'
            'status' => $this->boolean()->notNull()->defaultValue(0),
            'message' => $this->string(191)->notNull()->defaultValue('Redirecting to PayPal'),
            'intent' => $this->string(191)->notNull()->defaultValue('sale'), // 'sale', 'authorize' or 'order'

            // Payment
            'payment_method' => $this->string(191)->notNull()->defaultValue('paypal'), // 'paypal' or 'credit_card'
            'payment_description' => $this->text(),

            // Credit Card
            'credit_card_number' => $this->text(),
            'credit_card_type' => $this->text(), // Valid types are: visa, mastercard, discover, amex
            'credit_card_expire_month' => $this->text(), // Acceptable values are 1 through 12. No zero.
            'credit_card_expire_year' => $this->text(), // 4-digit expiration year
            'credit_card_cvv2' => $this->text(), // 3-4 digit card validation code.
            'credit_card_first_name' => $this->text(), // Cardholder’s first name
            'credit_card_last_name' => $this->text(), // Cardholder’s last name.

            // Default settings
            'shipping' => $this->text(),
            'handling' => $this->text(),
            'tax' => $this->text(),
            'currency' => $this->string(3)->notNull()->defaultValue('USD'), // 3-letter currency code

            // Used for shipping or billing addresses
            'address_line1' => $this->text(), // Line 1 of the Address (E.g. number, street, etc). Required.
            'address_line2' => $this->text(), // Optional line 2 of the Address (E.g. suite, apt #, etc.).
            'address_city' => $this->text(), // Required. E.g. 'Johnstown'
            'address_country_code' => $this->text(), // 2-letter country code Required. E.g. 'US'
            'address_postal_code' => $this->text(), // Zip code or equivalent. E.g. '43210'
            'address_state' => $this->text(), // 2-letter code for US states and equivalents. E.g. 'OH'
            'address_phone' => $this->text(), // Phone number in E.123 format.

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),

        ], $tableOptions);

        $this->createTable('{{%addon_paypal_item}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'quantity' => $this->text(), // Number of a particular item
            'name' => $this->string(127), // Item name
            'price' => $this->text(), // Item cost
            'currency' => $this->string(3)->notNull()->defaultValue('USD'), // 3-letter currency code
            'sku' => $this->string(50), // Stock keeping unit corresponding (SKU) to item
            'description' => $this->string(127), // Only supported when the payment_method is set to 'paypal'
            'tax' => $this->string(10), // Tax of the item. Only supported when the payment_method is set to 'paypal'
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_paypal_item}}');
        $this->dropTable('{{%addon_paypal}}');
    }
}
