<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 */
namespace app\modules\addons\modules\neverbounce\services;

use Yii;

/**
 * Class NeverBounceService
 * @package app\modules\addons\modules\neverbounce\services
 */
class NeverBounceService
{
    public $apiKey;

    public function __construct($api_key)
    {
        $this->apiKey = $api_key;
    }

    public function validateEmail($email)
    {
        /*
         * Set up cURL
         */
        $c=curl_init(sprintf("https://api.neverbounce.com/v4/single/check?key=%s&email=%s", $this->apiKey, urlencode($email)));
        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($c, CURLOPT_FAILONERROR, false);
        curl_setopt($c, CURLOPT_TIMEOUT, 5);
        curl_setopt($c, CURLOPT_CUSTOMREQUEST, "POST");

        /*
         * Run cURL, parse info, and close it
         */
        $results = curl_exec($c);
        $info = curl_getinfo($c);
        curl_close($c);

        /*
         * Decode the JSON results
         */
        $answer = json_decode($results);

        /*
        * Make sure you have a valid HTTP status code, and it parsed into the expected JSON object
        */
        if (isset($info['http_code'], $answer->result) && $info['http_code']) {
            // https://neverbounce.com/help/understanding-and-downloading-results/result-codes
            return in_array($answer->result, ["valid", "catchall", "unknown"]);
        }

        // Log connection error
        Yii::error("Could not talk to NeverBounce servers.");

    }
}